/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.IComboDamage;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.network.server.TargetIdPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SwordBasic
extends SkillActive
implements ICombo,
ILockOnTarget {
    private boolean isActive = false;
    private EntityLivingBase currentTarget = null;
    @SideOnly(value=Side.CLIENT)
    private EntityLivingBase prevTarget;
    private Combo combo = null;

    public SwordBasic(String name) {
        super(name);
    }

    private SwordBasic(SwordBasic skill) {
        super(skill);
    }

    @Override
    public SwordBasic newInstance() {
        return new SwordBasic(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{this.getMaxComboSize()}));
        desc.add(this.getTimeLimitDisplay(this.getComboTimeLimit()));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", Float.valueOf(0.5f * (float)this.level))}));
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return this.level > 0;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean hasAnimation() {
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 0.0f;
    }

    @Override
    public byte getMaxLevel() {
        return 10;
    }

    private final int getComboTimeLimit() {
        return 20 + this.level * 2;
    }

    private final int getMaxComboSize() {
        return 2 + this.level;
    }

    private final int getRange() {
        return 6 + this.level;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        if (this.isActive) {
            this.onDeactivated(world, player);
        } else {
            this.isActive = true;
            if (!this.isComboInProgress()) {
                this.combo = null;
            }
            this.currentTarget = TargetUtils.acquireLookTarget((EntityLivingBase)player, this.getRange(), this.getRange(), true);
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
        this.currentTarget = null;
        if (world.isRemote) {
            this.prevTarget = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive() && player.worldObj.isRemote && (Minecraft.getMinecraft().currentScreen != null || !this.updateTargets(player))) {
            this.deactivate(player);
        }
        if (this.isComboInProgress()) {
            this.combo.onUpdate(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        float rYaw;
        double dx = player.posX - this.currentTarget.posX;
        double dz = player.posZ - this.currentTarget.posZ;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(player.posY - (this.currentTarget.posY + (double)(this.currentTarget.height / 2.0f)), Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = player.getDistanceToEntity((Entity)this.currentTarget);
        for (rYaw = (float)(angle - (double)player.rotationYaw); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        player.setAngles(rYaw += 90.0f, -(rPitch - player.rotationPitch));
        return false;
    }

    @Override
    public final boolean isLockedOn() {
        return this.currentTarget != null;
    }

    public final EntityLivingBase getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void setCurrentTarget(EntityPlayer player, Entity target) {
        if (target instanceof EntityLivingBase) {
            this.currentTarget = (EntityLivingBase)target;
        } else {
            this.deactivate(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getNextTarget(EntityPlayer player) {
        EntityLivingBase nextTarget = null;
        double dTarget = 0.0;
        List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, this.getRange(), this.getRange());
        for (EntityLivingBase entity : list) {
            if (entity == player || entity == this.currentTarget || entity == this.prevTarget || !this.isTargetValid(player, entity)) continue;
            if (nextTarget == null) {
                dTarget = player.getDistanceSqToEntity((Entity)entity);
                nextTarget = entity;
                continue;
            }
            double distance = player.getDistanceSqToEntity((Entity)entity);
            if (!(distance < dTarget)) continue;
            nextTarget = entity;
            dTarget = distance;
        }
        if (nextTarget != null) {
            this.prevTarget = this.currentTarget;
            this.currentTarget = nextTarget;
        } else {
            nextTarget = this.currentTarget;
            this.currentTarget = this.prevTarget;
            this.prevTarget = nextTarget;
        }
        PacketDispatcher.sendToServer(new TargetIdPacket(this));
    }

    @SideOnly(value=Side.CLIENT)
    private boolean updateTargets(EntityPlayer player) {
        if (!this.isTargetValid(player, this.prevTarget) || !TargetUtils.isTargetInSight((EntityLivingBase)player, (Entity)this.prevTarget)) {
            this.prevTarget = null;
        }
        if (!this.isTargetValid(player, this.currentTarget)) {
            this.currentTarget = null;
            if (Config.autoTargetEnabled()) {
                this.getNextTarget(player);
            }
        }
        return this.isTargetValid(player, this.currentTarget);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isTargetValid(EntityPlayer player, EntityLivingBase target) {
        return target != null && !target.isDead && target.getHealth() > 0.0f && player.getDistanceToEntity((Entity)target) < (float)this.getRange() && !target.isInvisible() && (Config.canTargetPlayers() || !(target instanceof EntityPlayer));
    }

    @Override
    public final Combo getCombo() {
        return this.combo;
    }

    @Override
    public final void setCombo(Combo combo) {
        this.combo = combo;
    }

    @Override
    public final boolean isComboInProgress() {
        return this.combo != null && !this.combo.isFinished();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onAttack(EntityPlayer player) {
        boolean attackHit;
        Entity mouseOver = TargetUtils.getMouseOverEntity();
        boolean bl = attackHit = this.isLockedOn() && mouseOver != null && TargetUtils.canReachTarget(player, mouseOver);
        if (!attackHit) {
            PlayerUtils.playRandomizedSound(player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
            if (this.isComboInProgress()) {
                PacketDispatcher.sendToServer(new EndComboPacket(this));
            }
        }
        return attackHit;
    }

    @Override
    public void onHurtTarget(EntityPlayer player, LivingHurtEvent event) {
        String sound;
        float damage;
        if (!this.isLockedOn() || !this.isValidComboDamage(player, event.source)) {
            return;
        }
        if (this.combo == null || this.combo.isFinished()) {
            this.combo = new Combo(player, this, this.getMaxComboSize(), this.getComboTimeLimit());
        }
        if ((damage = DirtyEntityAccessor.getModifiedDamage(event.entityLiving, event.source, event.ammount)) > 0.0f) {
            if (!(event.source instanceof IComboDamage.IComboDamageFull) || ((IComboDamage.IComboDamageFull)event.source).increaseComboCount(player)) {
                this.combo.add(player, (Entity)event.entityLiving, damage);
            } else {
                this.combo.addDamageOnly(player, damage);
            }
        }
        if ((sound = this.getComboDamageSound(player, event.source)) != null) {
            PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, sound, 0.4f, 0.5f);
        }
    }

    private boolean isValidComboDamage(EntityPlayer player, DamageSource source) {
        if (source instanceof IComboDamage) {
            return ((IComboDamage)source).isComboDamage(player);
        }
        return !source.isProjectile();
    }

    private String getComboDamageSound(EntityPlayer player, DamageSource source) {
        if (source instanceof IComboDamage.IComboDamageFull && !((IComboDamage.IComboDamageFull)source).playDefaultSound(player)) {
            return ((IComboDamage.IComboDamageFull)source).getHitSound(player);
        }
        if (source.getDamageType().equals("player")) {
            return PlayerUtils.isSword(player.getHeldItem()) ? "dynamicswordskills:swordcut" : "dynamicswordskills:hurtflesh";
        }
        return null;
    }

    @Override
    public void onPlayerHurt(EntityPlayer player, LivingHurtEvent event) {
        if (this.isComboInProgress() && DirtyEntityAccessor.getModifiedDamage((EntityLivingBase)player, event.source, event.ammount) > 0.5f * (float)this.level) {
            this.combo.endCombo(player);
        }
    }
}

