/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Parry
extends SkillActive {
    private int parryTimer;
    private int attacksParried;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public Parry(String name) {
        super(name);
    }

    private Parry(Parry skill) {
        super(skill);
    }

    @Override
    public Parry newInstance() {
        return new Parry(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 1), (Object[])new Object[]{(int)(this.getDisarmChance(player, null) * 100.0f)}));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 2), (Object[])new Object[]{(int)(2.5f * (float)(this.getActiveTime() - this.getParryDelay()))}));
        desc.add(StatCollector.translateToLocalFormatted((String)this.getInfoString("info", 3), (Object[])new Object[]{this.getMaxParries()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getParryDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.parryTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.3f - 0.02f * (float)this.level;
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getParryDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxParries() {
        return (1 + this.level) / 2;
    }

    private float getDisarmChance(EntityPlayer player, EntityLivingBase attacker) {
        float penalty = 0.0f;
        float bonus = Config.getDisarmTimingBonus() * (float)(this.parryTimer > 0 ? this.parryTimer - this.getParryDelay() : 0);
        if (attacker instanceof EntityPlayer) {
            penalty = Config.getDisarmPenalty() * (float)DSSPlayerInfo.get((EntityPlayer)attacker).getSkillLevel(this);
        }
        return (float)this.level * 0.1f - penalty + bonus;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.getHeldItem());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && !PlayerUtils.isBlocking(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[5] || Config.allowVanillaControls() && key == mc.gameSettings.keyBindBack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requiresDoubleTap()) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.gameSettings.keyBindBack) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.parryTimer = this.getActiveTime();
        this.attacksParried = 0;
        this.playMissSound = true;
        player.swingItem();
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.parryTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.parryTimer <= this.getParryDelay() && this.playMissSound) {
                this.playMissSound = false;
                PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.worldObj.isRemote && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.getEntity();
            if (this.attacksParried < this.getMaxParries() && this.parryTimer > this.getParryDelay() && attacker.getHeldItem() != null && PlayerUtils.isWeapon(player.getHeldItem())) {
                if (player.worldObj.rand.nextFloat() < this.getDisarmChance(player, attacker)) {
                    PlayerUtils.dropHeldItem(attacker);
                }
                ++this.attacksParried;
                PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, "dynamicswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }
}

