/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.client.MortalDrawPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MortalDraw
extends SkillActive {
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;
    private Entity target;

    public MortalDraw(String name) {
        super(name);
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(100, true) + "%");
        desc.add(this.getTimeLimitDisplay(this.getAttackTime() - 30));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 28;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.attackTimer > 25;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private int getDamageMultiplier() {
        return 100 + 10 * this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        this.swordSlot = -1;
        if (super.canUse(player) && player.getHeldItem() == null && this.attackTimer == 0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.inventory.getStackInSlot(i);
                if (stack == null || !PlayerUtils.isSwordOrProvider(stack, this)) continue;
                this.swordSlot = i;
                break;
            }
        }
        return this.swordSlot > -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.getHeldItem() == null && (Minecraft.getMinecraft().gameSettings.keyBindUseItem.getIsKeyPressed() || DSSKeyHandler.keys[6].getIsKeyPressed());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.gameSettings.keyBindAttack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.attackTimer = this.getAttackTime();
        this.target = null;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.attackTimer = 0;
        this.swordSlot = -1;
        this.target = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.worldObj.isRemote) {
                this.drawSword(player, null);
                if (player.getHeldItem() != null) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (!player.worldObj.isRemote && source.getEntity() != null) {
            if (this.target == source.getEntity()) {
                return true;
            }
            if (this.attackTimer > 30) {
                if (this.drawSword(player, source.getEntity())) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                    this.target = source.getEntity();
                    return true;
                }
                this.attackTimer = 30;
                this.target = null;
            }
        }
        return false;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        if (this.attackTimer > 30) {
            this.attackTimer = 30;
            event.ammount *= 1.0f + (float)this.getDamageMultiplier() / 100.0f;
            PlayerUtils.playSoundAtEntity(player.worldObj, (Entity)player, "dynamicswordskills:mortaldraw", 0.4f, 0.5f);
        } else {
            this.target = null;
        }
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        boolean flag = false;
        if (this.swordSlot > -1 && this.swordSlot != player.inventory.currentItem && player.getHeldItem() == null) {
            ItemStack sword = player.inventory.getStackInSlot(this.swordSlot);
            if (!player.worldObj.isRemote) {
                player.inventory.setInventorySlotContents(this.swordSlot, null);
            }
            player.setCurrentItemOrArmor(0, sword);
            player.getAttributeMap().applyAttributeModifiers(sword.getAttributeModifiers());
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            flag = skill != null && skill.getCurrentTarget() == attacker;
        }
        this.swordSlot = -1;
        return flag;
    }
}

