/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class TargetIdPacket
extends AbstractMessage.AbstractServerMessage<TargetIdPacket> {
    private byte skillId;
    private Entity targetEntity;
    private int entityId;
    boolean isNull = false;

    public TargetIdPacket() {
    }

    public <T extends SkillBase> TargetIdPacket(T skill) {
        this.skillId = skill.getId();
        this.targetEntity = ((ILockOnTarget)((Object)skill)).getCurrentTarget();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        if (buffer.readByte() == 1) {
            this.skillId = buffer.readByte();
            this.entityId = buffer.readInt();
        } else {
            this.isNull = true;
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        if (this.targetEntity != null) {
            buffer.writeByte(1);
            buffer.writeByte((int)this.skillId);
            buffer.writeInt(this.targetEntity.getEntityId());
        } else {
            buffer.writeByte(0);
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
        if (skill != null) {
            if (this.isNull) {
                skill.setCurrentTarget(player, null);
            } else {
                this.targetEntity = player.worldObj.getEntityByID(this.entityId);
                skill.setCurrentTarget(player, this.targetEntity);
                if (this.targetEntity == null) {
                    DynamicSwordSkills.logger.warn("Invalid target; entity with id " + this.entityId + " is null");
                }
            }
        }
    }
}

