/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncPlayerInfoPacket;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "DSSPlayerInfo";
    private final EntityPlayer player;
    private final Map<Byte, SkillBase> skills;
    private SkillBase itemSkill = null;
    private ItemStack lastCheckedStack = null;
    private SkillBase dummySwordSkill = null;
    private int persistentDummySkillSlot = -1;
    private final List<SkillActive> activeSkills = new LinkedList<SkillActive>();
    @SideOnly(value=Side.CLIENT)
    private SkillActive animatingSkill;
    private boolean receivedGear = false;
    public float reduceFallAmount = 0.0f;

    public DSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.skills = new HashMap<Byte, SkillBase>(SkillBase.getNumSkills());
    }

    public void init(Entity entity, World world) {
    }

    public boolean removeSkill(String name) {
        if ("all".equals(name)) {
            this.resetSkills();
            return true;
        }
        SkillBase dummy = null;
        for (SkillBase skill : this.skills.values()) {
            if (!skill.getUnlocalizedName().equals(name)) continue;
            dummy = skill;
            break;
        }
        if (dummy != null) {
            this.removeSkill(dummy);
            return true;
        }
        return false;
    }

    private void removeSkill(SkillBase skill) {
        SkillBase dummy = skill.newInstance();
        this.skills.put(dummy.getId(), dummy);
        this.validateSkills();
        this.skills.remove(dummy.getId());
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncSkillPacket(dummy), (EntityPlayerMP)this.player);
        }
    }

    public void resetSkills() {
        for (SkillBase skill : SkillBase.getSkills()) {
            this.skills.put(skill.getId(), skill.newInstance());
        }
        this.validateSkills();
        this.skills.clear();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this).setReset(), (EntityPlayerMP)this.player);
        }
    }

    public boolean hasSkill(SkillBase skill) {
        return this.hasSkill(skill.getId());
    }

    private boolean hasSkill(byte id) {
        return this.getSkillLevel(id) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        return this.getSkillLevel(skill.getId());
    }

    public byte getSkillLevel(byte id) {
        byte level;
        block6: {
            block7: {
                block5: {
                    level = 0;
                    if (this.itemSkill == null || this.itemSkill.getId() != id) break block5;
                    level = this.itemSkill.getLevel();
                    break block6;
                }
                if (id != SkillBase.swordBasic.getId()) break block7;
                if (this.player.getHeldItem() == null) {
                    this.retrieveDummySwordSkill();
                }
                if (this.dummySwordSkill == null) break block6;
                level = this.dummySwordSkill.getLevel();
                break block6;
            }
            if (id == SkillBase.mortalDraw.getId() && (this.itemSkill == null || this.dummySwordSkill == null)) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = this.player.inventory.getStackInSlot(i);
                    if (stack == null || !(stack.getItem() instanceof ISkillProvider) || ((ISkillProvider)stack.getItem()).getSkillId(stack) != id) continue;
                    if (this.itemSkill == null) {
                        this.itemSkill = SkillBase.getSkillFromItem(stack, (ISkillProvider)stack.getItem());
                        if (this.itemSkill != null && this.itemSkill.getLevel() > this.getTrueSkillLevel(id)) {
                            level = this.itemSkill.getLevel();
                        }
                    }
                    if (this.dummySwordSkill != null || !((ISkillProvider)stack.getItem()).grantsBasicSwordSkill(stack) || this.getTrueSkillLevel(SkillBase.swordBasic.getId()) >= 1) break;
                    this.dummySwordSkill = SkillBase.createLeveledSkill(SkillBase.swordBasic.getId(), (byte)1);
                    this.persistentDummySkillSlot = i;
                    break;
                }
            }
        }
        return (byte)Math.max(level, this.getTrueSkillLevel(id));
    }

    public byte getTrueSkillLevel(SkillBase skill) {
        return this.getTrueSkillLevel(skill.getId());
    }

    private byte getTrueSkillLevel(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id).getLevel() : (byte)0;
    }

    public boolean canUseSkill(SkillBase skill) {
        SkillActive active = this.getActiveSkill(skill);
        return active != null && active.canUse(this.player);
    }

    public boolean isSkillActive(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill);
        return active instanceof SkillActive && ((SkillActive)active).isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public SkillActive getCurrentlyAnimatingSkill() {
        return this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCurrentlyAnimatingSkill(SkillActive skill) {
        this.animatingSkill = skill == null || skill.hasAnimation() ? skill : this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canInteract() {
        if (this.animatingSkill != null && !this.animatingSkill.isActive() && !this.animatingSkill.isAnimating()) {
            this.animatingSkill = null;
        }
        return this.animatingSkill == null || !this.animatingSkill.isAnimating();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyPressed(Minecraft mc, KeyBinding key) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isKeyListener(mc, key) || !((SkillActive)skill).keyPressed(mc, key, this.player)) continue;
            return true;
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isKeyListener(mc, key)) {
            return ((SkillActive)this.itemSkill).keyPressed(mc, key, this.player);
        }
        return false;
    }

    public void onBeingAttacked(LivingAttackEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive() || !skill.onBeingAttacked(this.player, event.source)) continue;
            event.setCanceled(true);
            return;
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            ((SkillActive)this.itemSkill).onBeingAttacked(this.player, event.source);
        }
    }

    public void onPostImpact(LivingHurtEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive()) continue;
            event.ammount = skill.postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            event.ammount = ((SkillActive)this.itemSkill).postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.getComboSkill() != null) {
            this.getComboSkill().onHurtTarget(this.player, event);
        }
    }

    private void retrieveDummySwordSkill() {
        boolean needsDummy;
        boolean bl = needsDummy = this.getTrueSkillLevel(SkillBase.swordBasic.getId()) < 1 && this.dummySwordSkill == null;
        if ((needsDummy || this.itemSkill == null) && this.persistentDummySkillSlot == -1) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.player.inventory.getStackInSlot(i);
                if (stack == null || !(stack.getItem() instanceof ISkillProvider) || ((ISkillProvider)stack.getItem()).getSkillId(stack) != SkillBase.mortalDraw.getId()) continue;
                if (needsDummy && ((ISkillProvider)stack.getItem()).grantsBasicSwordSkill(stack)) {
                    this.dummySwordSkill = SkillBase.createLeveledSkill(SkillBase.swordBasic.getId(), (byte)1);
                    this.persistentDummySkillSlot = i;
                }
                if (this.itemSkill == null) {
                    this.itemSkill = SkillBase.getSkillFromItem(stack, (ISkillProvider)stack.getItem());
                }
                if (!needsDummy || this.dummySwordSkill != null) break;
            }
            if (this.dummySwordSkill == null) {
                this.persistentDummySkillSlot = -30;
            }
        }
    }

    public SkillActive getActiveSkill(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill.getId());
        return active instanceof SkillActive ? (SkillActive)active : null;
    }

    public SkillBase getPlayerSkill(SkillBase skill) {
        return this.getPlayerSkill(skill.getId());
    }

    public SkillBase getPlayerSkill(byte id) {
        if (this.itemSkill != null && this.itemSkill.getId() == id) {
            return this.itemSkill;
        }
        if (id == SkillBase.spinAttack.getId() && this.itemSkill != null && this.itemSkill.getId() == SkillBase.superSpinAttack.getId()) {
            SkillBase skill = this.getTruePlayerSkill(id);
            return skill == null && !Config.isSpinAttackRequired() ? this.itemSkill : skill;
        }
        if (id == SkillBase.swordBasic.getId()) {
            if (this.player.getHeldItem() == null) {
                this.retrieveDummySwordSkill();
            }
            return this.dummySwordSkill == null ? this.getTruePlayerSkill(id) : this.dummySwordSkill;
        }
        return this.getTruePlayerSkill(id);
    }

    public SkillBase getTruePlayerSkill(SkillBase skill) {
        return this.getTruePlayerSkill(skill.getId());
    }

    private SkillBase getTruePlayerSkill(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id) : null;
    }

    public ICombo getComboSkill() {
        SkillBase skill = this.getPlayerSkill(SkillBase.swordBasic);
        if (skill != null && (((ICombo)((Object)skill)).getCombo() != null || ((SkillActive)skill).isActive())) {
            return (ICombo)((Object)skill);
        }
        return null;
    }

    public ILockOnTarget getTargetingSkill() {
        return (ILockOnTarget)((Object)this.getPlayerSkill(SkillBase.swordBasic));
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill.getId(), (byte)(this.getSkillLevel(skill) + 1));
    }

    public boolean grantSkill(byte id, byte targetLevel) {
        SkillBase skill;
        SkillBase skillBase = skill = this.skills.containsKey(id) ? this.skills.get(id) : SkillBase.getNewSkillInstance(id);
        if (skill.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, skill);
            return true;
        }
        return false;
    }

    private void onSkillActivated(World world, SkillActive skill) {
        if (skill.isActive()) {
            this.activeSkills.add(skill);
            if (world.isRemote) {
                this.setCurrentlyAnimatingSkill(skill);
            }
        }
    }

    public boolean activateSkill(World world, SkillBase skill) {
        return this.activateSkill(world, skill.getId());
    }

    public boolean activateSkill(World world, byte id) {
        SkillBase skill = this.getPlayerSkill(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).activate(world, this.player)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    public boolean triggerSkill(World world, SkillBase skill) {
        return this.triggerSkill(world, skill.getId());
    }

    public boolean triggerSkill(World world, byte id) {
        SkillBase skill = this.getPlayerSkill(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).trigger(world, this.player, true)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(byte id, NBTTagCompound compound) {
        if (SkillBase.doesSkillExist(id)) {
            SkillBase skill = SkillBase.getNewSkillInstance(id).loadFromNBT(compound);
            if (skill.getLevel() > 0) {
                this.skills.put(id, skill);
            } else {
                this.skills.remove(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(float partialRenderTick) {
        boolean flag = false;
        if (this.animatingSkill != null) {
            if (this.animatingSkill.isAnimating()) {
                flag = this.animatingSkill.onRenderTick(this.player, partialRenderTick);
            } else if (!this.animatingSkill.isActive()) {
                this.setCurrentlyAnimatingSkill(null);
            }
        }
        ILockOnTarget skill = this.getTargetingSkill();
        if (!flag && skill != null && skill.isLockedOn()) {
            ((SkillActive)((Object)skill)).onRenderTick(this.player, partialRenderTick);
        }
    }

    public void onUpdate() {
        this.updateISkillItem();
        if (this.itemSkill != null) {
            this.itemSkill.onUpdate(this.player);
        }
        if (this.dummySwordSkill != null) {
            this.dummySwordSkill.onUpdate(this.player);
        }
        if (this.persistentDummySkillSlot < -1) {
            ++this.persistentDummySkillSlot;
        }
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        Iterator<SkillActive> iterator = this.activeSkills.iterator();
        while (iterator.hasNext()) {
            SkillBase skill;
            skill = iterator.next();
            if (((SkillActive)skill).isActive()) continue;
            iterator.remove();
        }
        if (this.player.worldObj.isRemote && DSSKeyHandler.keys[6].getIsKeyPressed() && this.isSkillActive(SkillBase.swordBasic) && this.player.getHeldItem() != null) {
            Minecraft.getMinecraft().playerController.sendUseItem(this.player, this.player.worldObj, this.player.getHeldItem());
        }
    }

    private void updateISkillItem() {
        ItemStack stack = this.player.getHeldItem();
        if (this.itemSkill != null && this.itemSkill.getId() == SkillBase.mortalDraw.getId() && (stack == null || ((SkillActive)this.itemSkill).isActive())) {
            ItemStack dummyStack;
            if (!(this.persistentDummySkillSlot <= -1 || stack != null || (dummyStack = this.player.inventory.getStackInSlot(this.persistentDummySkillSlot)) != null && dummyStack.getItem() instanceof ISkillProvider && SkillBase.getSkillFromItem(dummyStack, (ISkillProvider)dummyStack.getItem()).equals(this.itemSkill))) {
                boolean wasFound = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack newStack = this.player.inventory.getStackInSlot(i);
                    if (newStack == null || !(newStack.getItem() instanceof ISkillProvider) || !SkillBase.getSkillFromItem(newStack, (ISkillProvider)newStack.getItem()).equals(this.itemSkill)) continue;
                    this.persistentDummySkillSlot = i;
                    wasFound = true;
                    break;
                }
                if (!wasFound) {
                    this.itemSkill = null;
                    this.dummySwordSkill = null;
                    this.persistentDummySkillSlot = -1;
                }
            }
        } else if (stack != null && stack.getItem() instanceof ISkillProvider) {
            if (stack == this.lastCheckedStack) {
                return;
            }
            this.lastCheckedStack = stack;
            ISkillProvider item = (ISkillProvider)stack.getItem();
            SkillBase skill = SkillBase.getSkillFromItem(stack, item);
            if (this.itemSkill == null || !this.itemSkill.equals(skill)) {
                this.itemSkill = skill;
                if (this.itemSkill != null) {
                    if (this.itemSkill.getLevel() <= this.getTrueSkillLevel(this.itemSkill.getId())) {
                        this.itemSkill = null;
                    }
                    if (item.grantsBasicSwordSkill(stack) && skill.getId() != SkillBase.swordBasic.getId() && this.getTrueSkillLevel(SkillBase.swordBasic.getId()) < 1) {
                        if (this.dummySwordSkill == null) {
                            this.dummySwordSkill = SkillBase.createLeveledSkill(SkillBase.swordBasic.getId(), (byte)1);
                            this.persistentDummySkillSlot = -1;
                        }
                    } else {
                        this.dummySwordSkill = null;
                        this.persistentDummySkillSlot = -1;
                    }
                }
            }
        } else {
            this.itemSkill = null;
            this.dummySwordSkill = null;
            this.lastCheckedStack = null;
            if (this.persistentDummySkillSlot > -1) {
                this.persistentDummySkillSlot = -1;
            }
        }
    }

    public void verifyStartingGear() {
        if (!this.receivedGear && Config.giveBonusOrb()) {
            this.receivedGear = this.player.inventory.addItemStackToInventory(new ItemStack(DynamicSwordSkills.skillOrb, 1, (int)SkillBase.swordBasic.getId()));
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new DSSPlayerInfo(player));
    }

    public static final DSSPlayerInfo get(EntityPlayer player) {
        return (DSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void onPlayerLoggedIn() {
        this.verifyStartingGear();
    }

    public void onJoinWorld() {
        this.validateSkills();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this), (EntityPlayerMP)this.player);
        }
    }

    public void copy(DSSPlayerInfo info) {
        NBTTagCompound compound = new NBTTagCompound();
        info.saveNBTData(compound);
        this.loadNBTData(compound);
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            NBTTagCompound skillTag = new NBTTagCompound();
            skill.writeToNBT(skillTag);
            taglist.appendTag((NBTBase)skillTag);
        }
        compound.setTag("DynamicSwordSkills", (NBTBase)taglist);
        compound.setBoolean("receivedGear", this.receivedGear);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.skills.clear();
        NBTTagList taglist = compound.getTagList("DynamicSwordSkills", 10);
        for (int i = 0; i < taglist.tagCount(); ++i) {
            NBTTagCompound skill = taglist.getCompoundTagAt(i);
            byte id = skill.getByte("id");
            this.skills.put(id, SkillBase.getSkill(id).loadFromNBT(skill));
        }
        this.receivedGear = compound.getBoolean("receivedGear");
    }
}

