/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.client.RenderHelperQ;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.inventory.ContainerSkills;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiSkills
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("dynamicswordskills:textures/gui/gui_skills.png");
    private static final int MAX_LINES = 11;
    private SkillBase currentSkill = null;
    private final List<String> desc = new ArrayList<String>(50);
    private int textY;
    private float scrollY;
    private boolean isScrolling;
    private boolean wasClicking;
    private int numLines;
    private boolean isUnicode;
    private float xSize_lo;
    private float ySize_lo;

    public GuiSkills(EntityPlayer player) {
        super((Container)new ContainerSkills(player));
        this.xSize = 281;
        this.ySize = 180;
    }

    public void drawScreen(int mouseX, int mouseY, float f) {
        super.drawScreen(mouseX, mouseY, f);
        this.xSize_lo = mouseX;
        this.ySize_lo = mouseY;
        boolean flag = Mouse.isButtonDown((int)0);
        int x1 = this.guiLeft + 259;
        int y1 = this.guiTop + 61;
        if (!this.wasClicking && flag && this.isMouseInRegion(mouseX, mouseY, x1, x1 + 3, y1, y1 + 88)) {
            this.isScrolling = this.needsScrollBar();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.scrollY = ((float)(mouseY - y1) - 3.0f) / 81.0f;
            this.clampScrollBar();
        }
    }

    private boolean isMouseInRegion(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        return mouseX >= x1 && mouseX < x2 && mouseY >= y1 && mouseY < y2;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        int start;
        if (this.needsScrollBar()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            this.mc.renderEngine.bindTexture(texture);
            RenderHelperQ.drawTexturedRect(259.0, 55.0, 282, 0, 3, 5, 285, 180);
            RenderHelperQ.drawTexturedRect(259.0, 150.0, 282, 5, 3, 5, 285, 180);
            RenderHelperQ.drawTexturedRect(260.0, 61.0, 283, 17, 1, 88, 285, 180);
            RenderHelperQ.drawTexturedRect(259.0, 61 + (int)(this.scrollY * 81.0f), 282, 10, 3, 7, 285, 180);
            GL11.glPopAttrib();
        }
        String s = this.currentSkill != null ? this.currentSkill.getDisplayName().toUpperCase() : StatCollector.translateToLocal((String)"skill.dss.gui.description");
        this.isUnicode = this.fontRendererObj.getUnicodeFlag();
        this.fontRendererObj.setUnicodeFlag(true);
        this.fontRendererObj.drawString(s, 158, 38, 0x404040);
        if (this.currentSkill != null) {
            s = Config.isSkillEnabled(this.currentSkill.getId()) ? this.currentSkill.getLevelDisplay(false) : EnumChatFormatting.DARK_RED + StatCollector.translateToLocal((String)"skill.dss.disabled");
            this.fontRendererObj.drawString(s, 262 - this.fontRendererObj.getStringWidth(s), 38, 0x404040);
        }
        this.refreshDescription();
        this.textY = 38 + this.fontRendererObj.FONT_HEIGHT * 2;
        for (int i = start = this.needsScrollBar() ? (int)(this.scrollY * (float)(this.numLines - 11)) : 0; i < this.desc.size() && i < 11 + start; ++i) {
            this.fontRendererObj.drawString(this.desc.get(i), 158, this.textY, 0x404040);
            this.textY += this.fontRendererObj.FONT_HEIGHT;
        }
        this.fontRendererObj.setUnicodeFlag(this.isUnicode);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        RenderHelperQ.drawTexturedRect(texture, (double)this.guiLeft, (double)this.guiTop, 0, 0, this.xSize, this.ySize, 284, 180);
        GuiInventory.func_147046_a((int)(this.guiLeft + 73), (int)(this.guiTop + 105), (int)30, (float)((float)(this.guiLeft + 73) - this.xSize_lo), (float)((float)(this.guiTop + 55) - this.ySize_lo), (EntityLivingBase)this.mc.thePlayer);
    }

    private void refreshDescription() {
        String[] temp;
        if (!this.desc.isEmpty()) {
            return;
        }
        if (this.currentSkill != null) {
            this.desc.add(StatCollector.translateToLocal((String)"skill.dss.gui.summary"));
            this.currentSkill.addInformation(this.desc, (EntityPlayer)this.mc.thePlayer);
            this.desc.add("");
            this.desc.add(StatCollector.translateToLocal((String)"skill.dss.gui.activation"));
            this.desc.addAll(this.fontRendererObj.listFormattedStringToWidth(this.currentSkill.getActivationDisplay(), 101));
            this.desc.add("");
        }
        this.desc.add(StatCollector.translateToLocal((String)"skill.dss.gui.description"));
        for (String s : temp = this.currentSkill != null ? this.currentSkill.getFullDescription().split("\\\\n") : StatCollector.translateToLocal((String)"skill.dss.gui.explanation").split("\\\\n")) {
            this.desc.addAll(this.fontRendererObj.listFormattedStringToWidth(s, 101));
            this.desc.add("");
        }
        this.numLines = this.desc.size();
    }

    private boolean needsScrollBar() {
        return this.numLines > 11;
    }

    private void clampScrollBar() {
        if (this.scrollY < 0.0f) {
            this.scrollY = 0.0f;
        }
        if (this.scrollY > 1.0f) {
            this.scrollY = 1.0f;
        }
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        if (this.needsScrollBar()) {
            int i = Mouse.getEventDWheel();
            if (i != 0) {
                this.scrollY = i < 0 ? (this.scrollY += 1.0f / (float)(this.numLines - 11)) : (this.scrollY -= 1.0f / (float)(this.numLines - 11));
            }
            this.clampScrollBar();
        }
    }

    protected void mouseClickMove(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int which) {
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        if (slot != null && slot.getStack() != null) {
            int id = slot.getStack().getItemDamage() % SkillBase.getNumSkills();
            if (this.currentSkill == null || this.currentSkill.getId() != id) {
                this.scrollY = 0.0f;
                this.desc.clear();
            }
            this.currentSkill = DSSPlayerInfo.get((EntityPlayer)this.mc.thePlayer).getPlayerSkill((byte)id);
        }
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(k);
            if (!this.func_146978_c(slot.xDisplayPosition, slot.yDisplayPosition, 16, 16, x, y)) continue;
            return slot;
        }
        return null;
    }

    protected void keyTyped(char c, int key) {
        if (key == 1 || key == this.mc.gameSettings.keyBindInventory.getKeyCode() || key == DSSKeyHandler.keys[8].getKeyCode()) {
            this.mc.thePlayer.closeScreen();
        }
    }
}

