/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.server.OpenGuiPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class DSSKeyHandler {
    private final Minecraft mc = Minecraft.getMinecraft();
    public static final byte KEY_SKILL_ACTIVATE = 0;
    public static final byte KEY_NEXT_TARGET = 1;
    public static final byte KEY_ATTACK = 2;
    public static final byte KEY_LEFT = 3;
    public static final byte KEY_RIGHT = 4;
    public static final byte KEY_DOWN = 5;
    public static final byte KEY_BLOCK = 6;
    public static final byte KEY_TOGGLE_AUTOTARGET = 7;
    public static final byte KEY_SKILLS_GUI = 8;
    public static final byte KEY_TOGGLE_HUD = 9;
    public static final String[] desc = new String[]{"activate", "next", "attack", "left", "right", "down", "block", "toggleat", "skills_gui", "togglehud"};
    private static final int[] keyValues = new int[]{45, 15, 200, 203, 205, 208, 157, 52, 25, 47};
    public static final KeyBinding[] keys = new KeyBinding[desc.length];

    public DSSKeyHandler() {
        for (int i = 0; i < desc.length; ++i) {
            DSSKeyHandler.keys[i] = new KeyBinding("key.dss." + desc[i] + ".desc", keyValues[i], StatCollector.translateToLocal((String)"key.dss.label"));
            ClientRegistry.registerKeyBinding((KeyBinding)keys[i]);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            DSSKeyHandler.onKeyPressed(this.mc, Keyboard.getEventKey());
        }
    }

    public static void onKeyPressed(Minecraft mc, int kb) {
        if (mc.inGameHasFocus && mc.thePlayer != null) {
            DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)mc.thePlayer);
            if (kb == keys[0].getKeyCode()) {
                if (skills.hasSkill(SkillBase.swordBasic)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(SkillBase.swordBasic));
                }
            } else if (kb == keys[7].getKeyCode()) {
                if (mc.thePlayer.isSneaking()) {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "key.dss.toggletp", Config.toggleTargetPlayers() ? StatCollector.translateToLocal((String)"key.dss.enable") : StatCollector.translateToLocal((String)"key.dss.disable"));
                } else {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "key.dss.toggleat", Config.toggleAutoTarget() ? StatCollector.translateToLocal((String)"key.dss.enable") : StatCollector.translateToLocal((String)"key.dss.disable"));
                }
            } else if (kb == keys[8].getKeyCode()) {
                PacketDispatcher.sendToServer(new OpenGuiPacket(0));
            } else if (kb == keys[9].getKeyCode()) {
                Config.isComboHudEnabled = !Config.isComboHudEnabled;
                PlayerUtils.sendTranslatedChat((EntityPlayer)mc.thePlayer, "key.dss.togglehud", Config.isComboHudEnabled ? StatCollector.translateToLocal((String)"key.dss.enable") : StatCollector.translateToLocal((String)"key.dss.disable"));
            } else {
                DSSKeyHandler.handleTargetingKeys(mc, kb, skills);
            }
        }
    }

    private static void handleTargetingKeys(Minecraft mc, int kb, DSSPlayerInfo skills) {
        KeyBinding key;
        ILockOnTarget skill = skills.getTargetingSkill();
        boolean canInteract = skills.canInteract();
        if (skill == null || !skill.isLockedOn()) {
            return;
        }
        if (kb == keys[1].getKeyCode()) {
            skill.getNextTarget((EntityPlayer)mc.thePlayer);
        } else if (kb == keys[2].getKeyCode() || kb == mc.gameSettings.keyBindAttack.getKeyCode()) {
            boolean flag;
            KeyBinding key2 = kb == keys[2].getKeyCode() ? keys[2] : mc.gameSettings.keyBindAttack;
            boolean bl = flag = mc.thePlayer.attackTime > 0;
            if (canInteract && !flag) {
                KeyBinding.setKeyBindState((int)key2.getKeyCode(), (boolean)true);
            } else if (!flag) {
                if (skills.isSkillActive(SkillBase.spinAttack)) {
                    skills.getActiveSkill(SkillBase.spinAttack).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                    return;
                }
                if (skills.isSkillActive(SkillBase.backSlice)) {
                    skills.getActiveSkill(SkillBase.backSlice).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                    return;
                }
            }
            if (key2.getIsKeyPressed()) {
                if (!skills.onKeyPressed(mc, key2)) {
                    DSSClientEvents.performComboAttack(mc, skill);
                }
                if (skills.hasSkill(SkillBase.armorBreak)) {
                    skills.getActiveSkill(SkillBase.armorBreak).keyPressed(mc, key2, (EntityPlayer)mc.thePlayer);
                }
            }
        } else if (canInteract && (key = DSSKeyHandler.getKeyBindFromCode(mc, kb)) != null) {
            KeyBinding.setKeyBindState((int)kb, (boolean)true);
            skills.onKeyPressed(mc, key);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyBinding getKeyBindFromCode(Minecraft mc, int keyCode) {
        for (KeyBinding k : keys) {
            if (k.getKeyCode() != keyCode) continue;
            return k;
        }
        if (keyCode == mc.gameSettings.keyBindForward.getKeyCode()) {
            return mc.gameSettings.keyBindForward;
        }
        if (keyCode == mc.gameSettings.keyBindJump.getKeyCode()) {
            return mc.gameSettings.keyBindJump;
        }
        if (Config.allowVanillaControls()) {
            if (keyCode == mc.gameSettings.keyBindLeft.getKeyCode()) {
                return mc.gameSettings.keyBindLeft;
            }
            if (keyCode == mc.gameSettings.keyBindRight.getKeyCode()) {
                return mc.gameSettings.keyBindRight;
            }
            if (keyCode == mc.gameSettings.keyBindBack.getKeyCode()) {
                return mc.gameSettings.keyBindBack;
            }
        }
        return null;
    }
}

