/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncConfigPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.SkillBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class DSSCombatEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    private static void addDrop(Class<? extends EntityLivingBase> mobClass, SkillBase skill) {
        ItemStack stack = new ItemStack(DynamicSwordSkills.skillOrb, 1, (int)skill.getId());
        dropsList.put(mobClass, stack);
    }

    public static void initializeDrops() {
        DSSCombatEvents.addDrop(EntityZombie.class, SkillBase.swordBasic);
        DSSCombatEvents.addDrop(EntitySkeleton.class, SkillBase.swordBasic);
        DSSCombatEvents.addDrop(EntityEnderman.class, SkillBase.dodge);
        DSSCombatEvents.addDrop(EntitySilverfish.class, SkillBase.backSlice);
        DSSCombatEvents.addDrop(EntitySlime.class, SkillBase.dash);
        DSSCombatEvents.addDrop(EntityHorse.class, SkillBase.dash);
        DSSCombatEvents.addDrop(EntityPigZombie.class, SkillBase.parry);
        DSSCombatEvents.addDrop(EntityOcelot.class, SkillBase.mortalDraw);
        DSSCombatEvents.addDrop(EntitySpider.class, SkillBase.endingBlow);
        DSSCombatEvents.addDrop(EntityCaveSpider.class, SkillBase.leapingBlow);
        DSSCombatEvents.addDrop(EntityMagmaCube.class, SkillBase.leapingBlow);
        DSSCombatEvents.addDrop(EntityBlaze.class, SkillBase.spinAttack);
        DSSCombatEvents.addDrop(EntityBat.class, SkillBase.risingCut);
        DSSCombatEvents.addDrop(EntityCreeper.class, SkillBase.armorBreak);
        DSSCombatEvents.addDrop(EntityIronGolem.class, SkillBase.swordBreak);
        DSSCombatEvents.addDrop(EntityGhast.class, SkillBase.superSpinAttack);
        DSSCombatEvents.addDrop(EntityWitch.class, SkillBase.swordBeam);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob) {
        if (dropsList.get(mob.getClass()) != null && mob.worldObj.rand.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        boolean flag = mob instanceof EntityPlayer;
        int id = mob.worldObj.rand.nextInt(SkillBase.getNumSkills());
        if (SkillBase.doesSkillExist(id) && (!flag || Config.arePlayerDropsEnabled())) {
            float chance = (flag ? Config.getPlayerDropFactor() : 1.0f) * Config.getRandomMobDropChance();
            if (dropsList.get(mob.getClass()) != null || mob.worldObj.rand.nextFloat() < chance) {
                orb = new ItemStack(DynamicSwordSkills.skillOrb, 1, id);
            }
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        float baseChance;
        EntityLivingBase mob;
        ItemStack orb;
        if (event.source.getEntity() instanceof EntityPlayer && (orb = DSSCombatEvents.getOrbDrop(mob = event.entityLiving)) != null && (Config.areOrbDropsEnabled() || Config.arePlayerDropsEnabled() && event.entity instanceof EntityPlayer) && (baseChance = Config.getDropChance(orb.getItemDamage())) > 0.0f && mob.worldObj.rand.nextFloat() < baseChance + 0.005f * (float)event.lootingLevel) {
            event.drops.add(new EntityItem(mob.worldObj, mob.posX, mob.posY, mob.posZ, orb.copy()));
            mob.worldObj.playSoundEffect(mob.posX, mob.posY, mob.posZ, "dynamicswordskills:special_drop", 1.0f, 1.0f);
        }
    }

    public static void setPlayerAttackTime(EntityPlayer player) {
        if (!player.capabilities.isCreativeMode) {
            player.attackTime = Math.max(player.attackTime, Config.getBaseSwingSpeed());
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        if (!event.isCanceled() && event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onBeingAttacked(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent event) {
        ICombo combo;
        EntityPlayer player;
        if (event.source.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.getEntity();
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            ICombo combo2 = skills.getComboSkill();
            if (combo2 != null && combo2.getCombo() != null && !combo2.getCombo().isFinished()) {
                event.ammount += (float)combo2.getCombo().getNumHits();
            }
            if (skills.isSkillActive(SkillBase.armorBreak)) {
                ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).onImpact(player, event);
                return;
            }
            if (skills.isSkillActive(SkillBase.mortalDraw)) {
                ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).onImpact(player, event);
            }
        }
        if (event.ammount > 0.0f && event.entity instanceof EntityPlayer && (combo = DSSPlayerInfo.get(player = (EntityPlayer)event.entity).getComboSkill()) != null && event.ammount > 0.0f) {
            combo.onPlayerHurt(player, event);
        }
        if (event.ammount > 0.0f && event.source.getEntity() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.source.getEntity()).onPostImpact(event);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && DSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            DSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        DSSPlayerInfo.get(event.player).onPlayerLoggedIn();
        if (event.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncConfigPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        DSSPlayerInfo.get(event.entityPlayer).copy(DSSPlayerInfo.get(event.original));
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            if (skills.isSkillActive(SkillBase.leapingBlow)) {
                ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
            }
            if (skills.reduceFallAmount > 0.0f) {
                event.distance -= skills.reduceFallAmount;
                skills.reduceFallAmount = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        DSSPlayerInfo skills = DSSPlayerInfo.get(event.entityPlayer);
        if (skills != null && skills.isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(event.entityPlayer, event.distance);
        }
    }
}

