/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.entity.fx;

import com.gtnewhorizon.structurelib.StructureLib;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BlockHint
extends EntityFX {
    private IIcon[] icons;
    private short[] mRGBa = new short[]{255, 255, 255, 0};

    public BlockHint(World world) {
        this(world, 0, 0, 0, Blocks.stone, 0);
    }

    public BlockHint(World world, int x, int y, int z, IIcon[] icons) {
        super(world, (double)x + 0.25, (double)y + 0.5, (double)z + 0.25);
        this.particleGravity = 0.0f;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.noClip = true;
        this.particleMaxAge = 2000 + StructureLib.RANDOM.nextInt(200);
        this.icons = icons;
    }

    public BlockHint(World world, int x, int y, int z, Block block, int meta) {
        super(world, (double)x + 0.25, (double)y + 0.5, (double)z + 0.25);
        this.particleGravity = 0.0f;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.noClip = true;
        this.particleMaxAge = 2000 + StructureLib.RANDOM.nextInt(200);
        this.icons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            this.icons[i] = block.getIcon(i, meta);
        }
    }

    public BlockHint withColorTint(short[] coloure) {
        this.mRGBa = coloure;
        return this;
    }

    public void renderParticle(Tessellator tes, float subTickTime, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
        float size = 0.5f;
        float X = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)subTickTime - EntityFX.interpPosX);
        float Y = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)subTickTime - EntityFX.interpPosY) - size / 2.0f;
        float Z = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)subTickTime - EntityFX.interpPosZ);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        tes.setColorRGBA((int)((float)this.mRGBa[0] * 0.9f), (int)((float)this.mRGBa[1] * 0.95f), (int)((float)this.mRGBa[2] * 1.0f), 192);
        block8: for (int i = 0; i < 6; ++i) {
            if (this.icons[i] == null) continue;
            double u = this.icons[i].getMinU();
            double U = this.icons[i].getMaxU();
            double v = this.icons[i].getMinV();
            double V = this.icons[i].getMaxV();
            switch (i) {
                case 0: {
                    tes.addVertexWithUV((double)X, (double)Y, (double)(Z + size), u, V);
                    tes.addVertexWithUV((double)X, (double)Y, (double)Z, u, v);
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)Z, U, v);
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)(Z + size), U, V);
                    continue block8;
                }
                case 1: {
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)Z, u, v);
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)(Z + size), u, V);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)(Z + size), U, V);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)Z, U, v);
                    continue block8;
                }
                case 2: {
                    tes.addVertexWithUV((double)X, (double)Y, (double)Z, U, V);
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)Z, U, v);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)Z, u, v);
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)Z, u, V);
                    continue block8;
                }
                case 3: {
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)(Z + size), U, V);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)(Z + size), U, v);
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)(Z + size), u, v);
                    tes.addVertexWithUV((double)X, (double)Y, (double)(Z + size), u, V);
                    continue block8;
                }
                case 4: {
                    tes.addVertexWithUV((double)X, (double)Y, (double)(Z + size), U, V);
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)(Z + size), U, v);
                    tes.addVertexWithUV((double)X, (double)(Y + size), (double)Z, u, v);
                    tes.addVertexWithUV((double)X, (double)Y, (double)Z, u, V);
                    continue block8;
                }
                case 5: {
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)Z, U, V);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)Z, U, v);
                    tes.addVertexWithUV((double)(X + size), (double)(Y + size), (double)(Z + size), u, v);
                    tes.addVertexWithUV((double)(X + size), (double)Y, (double)(Z + size), u, V);
                }
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)true);
    }

    public int getFXLayer() {
        return 1;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 2;
    }
}

