/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class AlignmentMessage
implements IMessage {
    int mPosX;
    int mPosY;
    int mPosZ;
    int mPosD;
    int mAlign;

    public AlignmentMessage() {
    }

    public void fromBytes(ByteBuf pBuffer) {
        NBTTagCompound tTag = ByteBufUtils.readTag((ByteBuf)pBuffer);
        this.mPosX = tTag.getInteger("posx");
        this.mPosY = tTag.getInteger("posy");
        this.mPosZ = tTag.getInteger("posz");
        this.mPosD = tTag.getInteger("posd");
        this.mAlign = tTag.getInteger("rotf");
    }

    public void toBytes(ByteBuf pBuffer) {
        NBTTagCompound tFXTag = new NBTTagCompound();
        tFXTag.setInteger("posx", this.mPosX);
        tFXTag.setInteger("posy", this.mPosY);
        tFXTag.setInteger("posz", this.mPosZ);
        tFXTag.setInteger("posd", this.mPosD);
        tFXTag.setInteger("rotf", this.mAlign);
        ByteBufUtils.writeTag((ByteBuf)pBuffer, (NBTTagCompound)tFXTag);
    }

    private AlignmentMessage(IAlignmentProvider provider) {
        if (!(provider instanceof TileEntity)) {
            throw new IllegalArgumentException("Provider must be a TileEntity");
        }
        IAlignment alignment = provider.getAlignment();
        if (alignment == null) {
            throw new IllegalArgumentException("Passed in provider does not provide an alignment!");
        }
        TileEntity base = (TileEntity)provider;
        this.mPosX = base.xCoord;
        this.mPosY = base.yCoord;
        this.mPosZ = base.zCoord;
        this.mPosD = base.getWorldObj().provider.dimensionId;
        this.mAlign = alignment.getExtendedFacing().getIndex();
    }

    private AlignmentMessage(World world, int x, int y, int z, IAlignment front) {
        this.mPosX = x;
        this.mPosY = y;
        this.mPosZ = z;
        this.mPosD = world.provider.dimensionId;
        this.mAlign = front.getExtendedFacing().getIndex();
    }

    public static class ServerHandler
    implements IMessageHandler<AlignmentQuery, AlignmentData> {
        public AlignmentData onMessage(AlignmentQuery pMessage, MessageContext pCtx) {
            TileEntity te;
            WorldServer world = DimensionManager.getWorld((int)pMessage.mPosD);
            if (world != null && (te = world.getTileEntity(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IAlignmentProvider) {
                IAlignment alignment = ((IAlignmentProvider)te).getAlignment();
                if (alignment == null) {
                    return null;
                }
                pMessage.mAlign = alignment.getExtendedFacing().getIndex();
                return new AlignmentData(pMessage);
            }
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<AlignmentData, IMessage> {
        public IMessage onMessage(AlignmentData pMessage, MessageContext pCtx) {
            IAlignment alignment;
            TileEntity te;
            if (StructureLib.getCurrentPlayer().worldObj.provider.dimensionId == pMessage.mPosD && (te = StructureLib.getCurrentPlayer().worldObj.getTileEntity(pMessage.mPosX, pMessage.mPosY, pMessage.mPosZ)) instanceof IAlignmentProvider && (alignment = ((IAlignmentProvider)te).getAlignment()) != null) {
                alignment.setExtendedFacing(ExtendedFacing.byIndex(pMessage.mAlign));
            }
            return null;
        }
    }

    public static class AlignmentData
    extends AlignmentMessage {
        public AlignmentData() {
        }

        private AlignmentData(AlignmentQuery query) {
            this.mPosX = query.mPosX;
            this.mPosY = query.mPosY;
            this.mPosZ = query.mPosZ;
            this.mPosD = query.mPosD;
            this.mAlign = query.mAlign;
        }

        public AlignmentData(IAlignmentProvider provider) {
            super(provider);
        }

        public AlignmentData(World world, int x, int y, int z, IAlignment front) {
            super(world, x, y, z, front);
        }
    }

    public static class AlignmentQuery
    extends AlignmentMessage {
        public AlignmentQuery() {
        }

        public AlignmentQuery(IAlignmentProvider provider) {
            super(provider);
        }

        public AlignmentQuery(World world, int x, int y, int z, IAlignment front) {
            super(world, x, y, z, front);
        }
    }
}

