/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static String WailaStyle = "\u00a4";
    public static String WailaIcon = "\u00a5";
    public static String TAB = WailaStyle + WailaStyle + "a";
    public static String ALIGNRIGHT = WailaStyle + WailaStyle + "b";
    public static String ALIGNCENTER = WailaStyle + WailaStyle + "c";
    public static String HEART = WailaStyle + WailaIcon + "a";
    public static String HHEART = WailaStyle + WailaIcon + "b";
    public static String EHEART = WailaStyle + WailaIcon + "c";

    public static Block getBlockFromItemId(ItemStack itemId) {
        Item item = itemId.getItem();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.getItem() instanceof ItemPotion) {
            if (stack.stackSize == 1) {
                return new ItemStack(Items.glass_bottle);
            }
            stack.splitStack(1);
            return stack;
        }
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem(stack)) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }

    public static void giveExperience(EntityPlayer thePlayer, float experience) {
        int intExp = (int)experience;
        float fractional = experience - (float)intExp;
        if (fractional > 0.0f && (float)Math.random() < fractional) {
            ++intExp;
        }
        while (intExp > 0) {
            int j = EntityXPOrb.getXPSplit((int)intExp);
            intExp -= j;
            thePlayer.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(thePlayer.worldObj, thePlayer.posX, thePlayer.posY + 0.5, thePlayer.posZ + 0.5, j));
        }
    }

    public static BlockCoord canPlaceItem(ItemStack itemUsed, Block blockIdToBePlaced, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (blockIdToBePlaced == null) {
            return null;
        }
        Block block = world.getBlock(x, y, z);
        if (block == Blocks.snow_layer && (world.getBlockMetadata(x, y, z) & 7) < 1) {
            side = 1;
        } else if (!(block == Blocks.vine || block == Blocks.tallgrass || block == Blocks.deadbush || block != null && block.isReplaceable((IBlockAccess)world, x, y, z))) {
            if (side == 0) {
                --y;
            } else if (side == 1) {
                ++y;
            } else if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
        }
        if (itemUsed.stackSize == 0) {
            return null;
        }
        if (!player.canPlayerEdit(x, y, z, side, itemUsed)) {
            return null;
        }
        if (y == 255 && blockIdToBePlaced.getMaterial().isSolid()) {
            return null;
        }
        if (world.canPlaceEntityOnSide(blockIdToBePlaced, x, y, z, false, side, (Entity)player, itemUsed)) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }

    public static EntityItem createDrop(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.stackSize <= 0) {
            return null;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
            return entityitem;
        }
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.motionX = 0.0;
        entityitem.motionY = 0.0;
        entityitem.motionZ = 0.0;
        entityitem.delayBeforeCanPickup = 0;
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        EntityItem entityitem = Util.createEntityItem(world, stack, x, y, z, doRandomSpread);
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z) {
        return Util.createEntityItem(world, stack, x, y, z, true);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        EntityItem entityitem;
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
        } else {
            entityitem = new EntityItem(world, x, y, z, stack);
            entityitem.motionX = 0.0;
            entityitem.motionY = 0.0;
            entityitem.motionZ = 0.0;
            entityitem.delayBeforeCanPickup = 0;
        }
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, int x, int y, int z, boolean doRandomSpread) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d, (double)y + d1, (double)z + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        } else {
            EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
            entityitem.motionX = 0.0;
            entityitem.motionY = 0.0;
            entityitem.motionZ = 0.0;
            entityitem.delayBeforeCanPickup = 0;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public static void dropItems(World world, ItemStack[] inventory, int x, int y, int z, boolean doRandomSpread) {
        if (inventory == null) {
            return;
        }
        for (ItemStack stack : inventory) {
            if (stack == null || stack.stackSize <= 0) continue;
            Util.dropItems(world, stack.copy(), x, y, z, doRandomSpread);
        }
    }

    public static void dropItems(World world, IInventory inventory, int x, int y, int z, boolean doRandomSpread) {
        for (int l = 0; l < inventory.getSizeInventory(); ++l) {
            ItemStack items = inventory.getStackInSlot(l);
            if (items == null || items.stackSize <= 0) continue;
            Util.dropItems(world, inventory.getStackInSlot(l).copy(), x, y, z, doRandomSpread);
        }
    }

    public static boolean dumpModObjects(File file) {
        StringBuilder sb = new StringBuilder();
        for (Object key : Block.blockRegistry.getKeys()) {
            if (key == null) continue;
            sb.append(key.toString());
            sb.append("\n");
        }
        for (Object key : Item.itemRegistry.getKeys()) {
            if (key == null) continue;
            sb.append(key.toString());
            sb.append("\n");
        }
        try {
            Files.write((CharSequence)sb, (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean dumpOreNames(File file) {
        try {
            Object[] oreNames = OreDictionary.getOreNames();
            Files.write((CharSequence)Joiner.on((String)"\n").join(oreNames), (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static ItemStack decrStackSize(IInventory inventory, int slot, int size) {
        ItemStack item = inventory.getStackInSlot(slot);
        if (item != null) {
            if (item.stackSize <= size) {
                ItemStack result = item;
                inventory.setInventorySlotContents(slot, null);
                inventory.markDirty();
                return result;
            }
            ItemStack split = item.splitStack(size);
            if (item.stackSize == 0) {
                inventory.setInventorySlotContents(slot, null);
            }
            inventory.markDirty();
            return split;
        }
        return null;
    }

    public static Vec3 getEyePosition(EntityPlayer player) {
        Vec3 v = Vec3.createVectorHelper((double)player.posX, (double)player.posY, (double)player.posZ);
        if (player.worldObj.isRemote) {
            v.yCoord += (double)(player.getEyeHeight() - player.getDefaultEyeHeight());
        } else {
            v.yCoord += (double)player.getEyeHeight();
            if (player instanceof EntityPlayerMP && player.isSneaking()) {
                v.yCoord -= 0.08;
            }
        }
        return v;
    }

    public static Vector3d getEyePositionEio(EntityPlayer player) {
        Vector3d res = new Vector3d(player.posX, player.posY, player.posZ);
        if (player.worldObj.isRemote) {
            res.y += (double)(player.getEyeHeight() - player.getDefaultEyeHeight());
        } else {
            res.y += (double)player.getEyeHeight();
            if (player instanceof EntityPlayerMP && player.isSneaking()) {
                res.y -= 0.08;
            }
        }
        return res;
    }

    public static Vector3d getLookVecEio(EntityPlayer player) {
        Vec3 lv = player.getLookVec();
        return new Vector3d(lv.xCoord, lv.yCoord, lv.zCoord);
    }

    public static boolean isEquipped(EntityPlayer player, Class<? extends Item> class1) {
        if (player == null || player.inventory == null || player.inventory.getCurrentItem() == null) {
            return false;
        }
        return class1.isAssignableFrom(player.inventory.getCurrentItem().getItem().getClass());
    }

    public static boolean isType(ItemStack stack, Class<?> class1) {
        if (stack == null || class1 == null) {
            return false;
        }
        return class1.isAssignableFrom(stack.getItem().getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<MovingObjectPosition> raytraceAll(World world, Vec3 startVec, Vec3 endVec, boolean includeLiquids) {
        MovingObjectPosition movingobjectposition;
        ArrayList<MovingObjectPosition> result = new ArrayList<MovingObjectPosition>();
        boolean p_147447_4_ = false;
        boolean p_147447_5_ = false;
        if (Double.isNaN(startVec.xCoord)) return result;
        if (Double.isNaN(startVec.yCoord) || Double.isNaN(startVec.zCoord)) return result;
        if (Double.isNaN(endVec.xCoord) || Double.isNaN(endVec.yCoord) || Double.isNaN(endVec.zCoord)) return result;
        int i = MathHelper.floor_double((double)endVec.xCoord);
        int j = MathHelper.floor_double((double)endVec.yCoord);
        int k = MathHelper.floor_double((double)endVec.zCoord);
        int l = MathHelper.floor_double((double)startVec.xCoord);
        int i1 = MathHelper.floor_double((double)startVec.yCoord);
        int j1 = MathHelper.floor_double((double)startVec.zCoord);
        Block block = world.getBlock(l, i1, j1);
        int k1 = world.getBlockMetadata(l, i1, j1);
        if ((!p_147447_4_ || block.getCollisionBoundingBoxFromPool(world, l, i1, j1) != null) && block.canCollideCheck(k1, includeLiquids) && (movingobjectposition = block.collisionRayTrace(world, l, i1, j1, startVec, endVec)) != null) {
            result.add(movingobjectposition);
        }
        MovingObjectPosition movingobjectposition2 = null;
        k1 = 200;
        while (k1-- >= 0) {
            int b0;
            if (Double.isNaN(startVec.xCoord) || Double.isNaN(startVec.yCoord) || Double.isNaN(startVec.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                if (!p_147447_5_) return result;
                result.add(movingobjectposition2);
            }
            boolean flag6 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag6 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = endVec.xCoord - startVec.xCoord;
            double d7 = endVec.yCoord - startVec.yCoord;
            double d8 = endVec.zCoord - startVec.zCoord;
            if (flag6) {
                d3 = (d0 - startVec.xCoord) / d6;
            }
            if (flag3) {
                d4 = (d1 - startVec.yCoord) / d7;
            }
            if (flag4) {
                d5 = (d2 - startVec.zCoord) / d8;
            }
            boolean flag5 = false;
            if (d3 < d4 && d3 < d5) {
                b0 = i > l ? 4 : 5;
                startVec.xCoord = d0;
                startVec.yCoord += d7 * d3;
                startVec.zCoord += d8 * d3;
            } else if (d4 < d5) {
                b0 = j > i1 ? 0 : 1;
                startVec.xCoord += d6 * d4;
                startVec.yCoord = d1;
                startVec.zCoord += d8 * d4;
            } else {
                b0 = k > j1 ? 2 : 3;
                startVec.xCoord += d6 * d5;
                startVec.yCoord += d7 * d5;
                startVec.zCoord = d2;
            }
            Vec3 vec32 = Vec3.createVectorHelper((double)startVec.xCoord, (double)startVec.yCoord, (double)startVec.zCoord);
            vec32.xCoord = MathHelper.floor_double((double)startVec.xCoord);
            l = (int)vec32.xCoord;
            if (b0 == 5) {
                --l;
                vec32.xCoord += 1.0;
            }
            vec32.yCoord = MathHelper.floor_double((double)startVec.yCoord);
            i1 = (int)vec32.yCoord;
            if (b0 == 1) {
                --i1;
                vec32.yCoord += 1.0;
            }
            vec32.zCoord = MathHelper.floor_double((double)startVec.zCoord);
            j1 = (int)vec32.zCoord;
            if (b0 == 3) {
                --j1;
                vec32.zCoord += 1.0;
            }
            Block block1 = world.getBlock(l, i1, j1);
            int l1 = world.getBlockMetadata(l, i1, j1);
            if (p_147447_4_ && block1.getCollisionBoundingBoxFromPool(world, l, i1, j1) == null) continue;
            if (block1.canCollideCheck(l1, includeLiquids)) {
                MovingObjectPosition movingobjectposition1 = block1.collisionRayTrace(world, l, i1, j1, startVec, endVec);
                if (movingobjectposition1 == null) continue;
                result.add(movingobjectposition1);
                continue;
            }
            movingobjectposition2 = new MovingObjectPosition(l, i1, j1, b0, startVec, false);
        }
        if (!p_147447_5_) {
            return result;
        }
        result.add(movingobjectposition2);
        return result;
    }

    public static ForgeDirection getDirFromOffset(int xOff, int yOff, int zOff) {
        if (xOff != 0 && yOff == 0 && zOff == 0) {
            return xOff < 0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (zOff != 0 && yOff == 0 && xOff == 0) {
            return zOff < 0 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
        }
        if (yOff != 0 && xOff == 0 && zOff == 0) {
            return yOff < 0 ? ForgeDirection.DOWN : ForgeDirection.UP;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static int getProgressScaled(int scale, IProgressTile tile) {
        return (int)(tile.getProgress() * (float)scale);
    }
}

