/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.ItemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class InventoryWrapper
implements ISidedInventory {
    private IInventory inv;

    public static ISidedInventory asSidedInventory(IInventory inv) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            return (ISidedInventory)inv;
        }
        return new InventoryWrapper(inv);
    }

    public InventoryWrapper(IInventory inventory) {
        this.inv = ItemUtil.getInventory(inventory);
    }

    public IInventory getWrappedInv() {
        return this.inv;
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inv.getSizeInventory()) {
            return null;
        }
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < this.inv.getSizeInventory()) {
            this.inv.setInventorySlotContents(slot, itemStack);
        }
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        return slot >= 0 && slot < this.getSizeInventory() && this.inv.isItemValidForSlot(slot, itemStack);
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        int[] slots = new int[this.inv.getSizeInventory()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return slot >= 0 && slot < this.getSizeInventory();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }
}

