/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.enchant.EnchantXPBoost;
import com.enderio.core.common.util.Scheduler;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;

@Handlers.Handler
public class XPBoostHandler {
    private static final Method getExperiencePoints = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"e", "func_70693_a", "getExperiencePoints"}, (Class[])new Class[]{EntityPlayer.class});
    private static final String NBT_KEY = "ttCore:xpboost";

    @SubscribeEvent
    public void handleEntityKill(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        Entity killer = event.source.getSourceOfDamage();
        if (!entity.worldObj.isRemote && killer != null) {
            NBTTagCompound tag;
            if (killer instanceof EntityPlayer) {
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)killer));
            } else if (killer instanceof EntityArrow && ((EntityArrow)killer).shootingEntity instanceof EntityPlayer && (tag = killer.getEntityData()).hasKey(NBT_KEY) && tag.getInteger(NBT_KEY) >= 0) {
                int level = tag.getInteger(NBT_KEY);
                EntityArrow arrow = (EntityArrow)killer;
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)arrow.shootingEntity, level));
            }
        }
    }

    @SubscribeEvent
    public void handleArrowFire(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.entity;
            if (arrow.shootingEntity != null && arrow.shootingEntity instanceof EntityPlayer) {
                arrow.getEntityData().setInteger(NBT_KEY, this.getXPBoostLevel(((EntityPlayer)arrow.shootingEntity).getCurrentEquippedItem()));
            }
        }
    }

    @SubscribeEvent
    public void handleBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack held = event.getPlayer().getCurrentEquippedItem();
        if (held != null) {
            int xp;
            int level = this.getXPBoostLevel(held);
            int fortune = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)held);
            if (level >= 0 && (xp = event.block.getExpDrop((IBlockAccess)event.world, event.blockMetadata, fortune)) > 0) {
                event.world.spawnEntityInWorld((Entity)new EntityXPOrb(event.world, (double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, this.getXPBoost(xp, level)));
            }
        }
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player) {
        return this.getXPBoost(killed, player, this.getXPBoostLevel(player.getCurrentEquippedItem()));
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player, int level) {
        if (level >= 0) {
            try {
                int xp = (Integer)getExperiencePoints.invoke((Object)killed, player);
                return this.getXPBoost(xp, level);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return 0;
    }

    private int getXPBoost(int xp, int level) {
        return Math.round((float)xp * ((float)Math.log10(level + 1) * 2.0f));
    }

    private int getXPBoostLevel(ItemStack weapon) {
        if (weapon == null) {
            return -1;
        }
        Map enchants = EnchantmentHelper.getEnchantments((ItemStack)weapon);
        Iterator iterator = enchants.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Enchantment enchant = Enchantment.enchantmentsList[i];
            if (enchant != EnchantXPBoost.INSTANCE) continue;
            return (Integer)enchants.get(i);
        }
        return -1;
    }

    private void scheduleXP(Entity entity, int boost) {
        this.scheduleXP(entity.worldObj, entity.posX, entity.posY, entity.posZ, boost);
    }

    private void scheduleXP(final World world, final double x, final double y, final double z, final int boost) {
        if (boost <= 0) {
            return;
        }
        Scheduler.instance().schedule(20, new Runnable(){

            @Override
            public void run() {
                world.spawnEntityInWorld((Entity)new EntityXPOrb(world, x, y, z, boost));
            }
        });
    }
}

