/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.enchant.EnchantAutoSmelt;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.world.BlockEvent;

@Handlers.Handler
public class AutoSmeltHandler {
    @SubscribeEvent
    public void handleBlockBreak(BlockEvent.HarvestDropsEvent event) {
        ItemStack held;
        if (!event.world.isRemote && event.harvester != null && (held = event.harvester.getCurrentEquippedItem()) != null) {
            int level = this.getAutoSmeltLevel(held);
            int fortune = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)held);
            if (level >= 0) {
                for (int i = 0; i < event.drops.size(); ++i) {
                    int j;
                    ItemStack stack = (ItemStack)event.drops.get(i);
                    if (stack == null || event.isSilkTouching || FurnaceRecipes.smelting().getSmeltingResult(stack) == null) continue;
                    ItemStack furnaceStack = FurnaceRecipes.smelting().getSmeltingResult(stack).copy();
                    if (fortune > 0 && ConfigHandler.allowAutoSmeltWithFortune) {
                        furnaceStack.stackSize *= event.world.rand.nextInt(fortune + 1) + 1;
                    }
                    event.drops.set(i, furnaceStack);
                    int xp = furnaceStack.stackSize;
                    float f = FurnaceRecipes.smelting().func_151398_b(furnaceStack);
                    if (f == 0.0f) {
                        xp = 0;
                    } else if (f < 1.0f) {
                        j = MathHelper.floor_float((float)((float)xp * f));
                        if (j < MathHelper.ceiling_float_int((float)((float)xp * f)) && (float)Math.random() < (float)xp * f - (float)j) {
                            ++j;
                        }
                        xp = j;
                    }
                    while (xp > 0) {
                        j = EntityXPOrb.getXPSplit((int)xp);
                        xp -= j;
                        event.world.spawnEntityInWorld((Entity)new EntityXPOrb(event.world, (double)event.x, (double)event.y + 0.5, (double)event.z, j));
                    }
                }
            }
        }
    }

    private int getAutoSmeltLevel(ItemStack tool) {
        if (tool == null) {
            return -1;
        }
        Map enchants = EnchantmentHelper.getEnchantments((ItemStack)tool);
        Iterator iterator = enchants.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Enchantment enchant = Enchantment.enchantmentsList[i];
            if (enchant != EnchantAutoSmelt.INSTANCE) continue;
            return (Integer)enchants.get(i);
        }
        return -1;
    }
}

