/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class TextFieldEnder
extends GuiTextField {
    public static final ICharFilter FILTER_NUMERIC = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return Character.isDigit(c) || c == '-' && Strings.isNullOrEmpty((String)tf.getText());
        }
    };
    public static ICharFilter FILTER_ALPHABETICAL = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return Character.isLetter(c);
        }
    };
    public static ICharFilter FILTER_ALPHANUMERIC = new ICharFilter(){

        @Override
        public boolean passesFilter(TextFieldEnder tf, char c) {
            return FILTER_NUMERIC.passesFilter(tf, c) || FILTER_ALPHABETICAL.passesFilter(tf, c);
        }
    };
    private final int xOrigin;
    private final int yOrigin;
    private ICharFilter filter;
    private static Field canLoseFocus;

    public TextFieldEnder(FontRenderer fnt, int x, int y, int width, int height) {
        this(fnt, x, y, width, height, null);
    }

    public TextFieldEnder(FontRenderer fnt, int x, int y, int width, int height, ICharFilter charFilter) {
        super(fnt, x, y, width, height);
        this.xOrigin = x;
        this.yOrigin = y;
        this.filter = charFilter;
    }

    public void init(IGuiScreen gui) {
        this.xPosition = this.xOrigin + gui.getGuiLeft();
        this.yPosition = this.yOrigin + gui.getGuiTop();
    }

    public TextFieldEnder setCharFilter(ICharFilter filter) {
        this.filter = filter;
        return this;
    }

    public boolean textboxKeyTyped(char c, int key) {
        if (this.filter == null || this.filter.passesFilter(this, c) || TextFieldEnder.isSpecialChar(c, key)) {
            return super.textboxKeyTyped(c, key);
        }
        return false;
    }

    public static boolean isSpecialChar(char c, int key) {
        return c == '\u0001' || c == '\u0003' || c == '\u0016' || c == '\u0018' || key == 14 || key == 199 || key == 203 || key == 205 || key == 207 || key == 211;
    }

    public boolean getCanLoseFocus() {
        try {
            return canLoseFocus.getBoolean((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.xPosition && x < this.xPosition + this.width && y >= this.yPosition && y < this.yPosition + this.height;
    }

    static {
        try {
            canLoseFocus = ReflectionHelper.findField(GuiTextField.class, (String[])new String[]{"canLoseFocus", "field_146212_n", "n"});
            canLoseFocus.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ICharFilter {
        public boolean passesFilter(TextFieldEnder var1, char var2);
    }
}

