/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.EnderWidget;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class IconButton
extends GuiButton {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    protected IWidgetIcon icon;
    private int xOrigin;
    private int yOrigin;
    protected IGuiScreen gui;
    protected String[] toolTipText;
    private GuiToolTip toolTip;
    private int marginY = 0;
    private int marginX = 0;

    public IconButton(IGuiScreen gui, int id, int x, int y, IWidgetIcon icon) {
        super(id, x, y, 16, 16, "");
        this.gui = gui;
        this.icon = icon;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public void setToolTip(String ... tooltipText) {
        if (this.toolTip == null) {
            this.toolTip = new GuiToolTip(this.getBounds(), tooltipText);
        } else {
            this.toolTip.setToolTipText(tooltipText);
        }
        this.toolTipText = tooltipText;
    }

    protected void setToolTip(GuiToolTip newToolTip) {
        boolean addTooltip = false;
        if (this.toolTip != null) {
            addTooltip = this.gui.removeToolTip(this.toolTip);
        }
        this.toolTip = newToolTip;
        if (addTooltip && this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.xOrigin, this.yOrigin, this.getWidth(), this.getHeight());
    }

    public void onGuiInit() {
        this.gui.addButton(this);
        if (this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.xPosition = this.xOrigin + this.gui.getGuiLeft();
        this.yPosition = this.yOrigin + this.gui.getGuiTop();
    }

    public void detach() {
        this.gui.removeToolTip(this.toolTip);
        this.gui.removeButton(this);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.updateTooltipBounds();
    }

    public IconButton setPosition(int x, int y) {
        this.xOrigin = x;
        this.yOrigin = y;
        this.updateTooltipBounds();
        return this;
    }

    private void updateTooltipBounds() {
        if (this.toolTip != null) {
            this.toolTip.setBounds(new Rectangle(this.xOrigin, this.yOrigin, this.width, this.height));
        }
    }

    public IconButton setIconMargin(int x, int y) {
        this.marginX = x;
        this.marginY = y;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public IWidgetIcon getIcon() {
        return this.icon;
    }

    public void setIcon(IWidgetIcon icon) {
        this.icon = icon;
    }

    public GuiToolTip getToolTip() {
        return this.toolTip;
    }

    public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
        return false;
    }

    protected boolean checkMousePress(Minecraft mc, int x, int y) {
        return super.mousePressed(mc, x, y);
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.toolTip != null) {
            this.toolTip.setVisible(this.visible);
        }
        if (this.visible) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int hoverState = this.getHoverState(this.field_146123_n);
            this.mouseDragged(mc, mouseX, mouseY);
            IWidgetIcon background = this.getIconForHoverState(hoverState);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int x = this.xPosition;
            int y = this.yPosition;
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            background.getMap().render(background, x, y, this.width, this.height, 0.0, true);
            if (this.icon != null) {
                this.icon.getMap().render(this.icon, x + this.marginX, y + this.marginY, this.width - 2 * this.marginX, this.height - 2 * this.marginY, 0.0, true);
            }
            GL11.glPopAttrib();
        }
    }

    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (hoverState == 0) {
            return EnderWidget.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return EnderWidget.BUTTON_HIGHLIGHT;
        }
        return EnderWidget.BUTTON;
    }
}

