/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.TransactorSimple;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.boards.BoardRobotPicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotFetchItem
extends AIRobot {
    private EntityItem target;
    private float maxRange;
    private IStackFilter stackFilter;
    private int pickTime = -1;
    private IZone zone;

    public AIRobotFetchItem(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchItem(EntityRobotBase iRobot, float iMaxRange, IStackFilter iStackFilter, IZone iZone) {
        this(iRobot);
        this.maxRange = iMaxRange;
        this.stackFilter = iStackFilter;
        this.zone = iZone;
    }

    @Override
    public void preempt(AIRobot ai) {
        if (this.target != null && this.target.field_70128_L) {
            this.terminate();
        }
    }

    @Override
    public void update() {
        if (this.target == null) {
            this.scanForItem();
        } else {
            ++this.pickTime;
            if (this.pickTime > 5) {
                TransactorSimple inventoryInsert = new TransactorSimple(this.robot);
                this.target.func_92059_d().field_77994_a -= inventoryInsert.inject(this.target.func_92059_d(), ForgeDirection.UNKNOWN, true);
                if (this.target.func_92059_d().field_77994_a <= 0) {
                    this.target.func_70106_y();
                }
                this.terminate();
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (this.target == null) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            if (!ai.success()) {
                this.robot.unreachableEntityDetected((Entity)this.target);
                this.setSuccess(false);
                this.terminate();
            }
        }
    }

    @Override
    public void end() {
        if (this.target != null) {
            BoardRobotPicker.targettedItems.remove(this.target.func_145782_y());
        }
    }

    private void scanForItem() {
        double previousDistance = Double.MAX_VALUE;
        TransactorSimple inventoryInsert = new TransactorSimple(this.robot);
        for (Object o : this.robot.field_70170_p.field_72996_f) {
            EntityItem item;
            double maxDistance;
            double dz;
            double dy;
            double dx;
            double sqrDistance;
            Entity e = (Entity)o;
            if (e.field_70128_L || !(e instanceof EntityItem) || BoardRobotPicker.targettedItems.contains(e.func_145782_y()) || this.robot.isKnownUnreachable(e) || this.zone != null && !this.zone.contains(e.field_70165_t, e.field_70163_u, e.field_70161_v) || (sqrDistance = (dx = e.field_70165_t - this.robot.field_70165_t) * dx + (dy = e.field_70163_u - this.robot.field_70163_u) * dy + (dz = e.field_70161_v - this.robot.field_70161_v) * dz) >= (maxDistance = (double)(this.maxRange * this.maxRange)) || this.stackFilter != null && !this.stackFilter.matches(((EntityItem)e).func_92059_d()) || inventoryInsert.inject((item = (EntityItem)e).func_92059_d(), ForgeDirection.UNKNOWN, false) <= 0) continue;
            if (this.target == null) {
                previousDistance = sqrDistance;
                this.target = item;
                continue;
            }
            if (!(sqrDistance < previousDistance)) continue;
            previousDistance = sqrDistance;
            this.target = item;
        }
        if (this.target != null) {
            BoardRobotPicker.targettedItems.add(this.target.func_145782_y());
            if (Math.floor(this.target.field_70165_t) != Math.floor(this.robot.field_70165_t) || Math.floor(this.target.field_70163_u) != Math.floor(this.robot.field_70163_u) || Math.floor(this.target.field_70161_v) != Math.floor(this.robot.field_70161_v)) {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, (int)Math.floor(this.target.field_70165_t), (int)Math.floor(this.target.field_70163_u), (int)Math.floor(this.target.field_70161_v)));
            }
        } else {
            this.setSuccess(false);
            this.terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 15;
    }
}

