/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.IDockingStationProvider;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.robotics.DockingStationPipe;
import buildcraft.robotics.EntityRobot;
import buildcraft.transport.PipeIconProvider;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class RobotStationPluggable
extends PipePluggable
implements IPipePluggableItem,
IEnergyReceiver,
IDebuggable,
IDockingStationProvider {
    private RobotStationState renderState;
    private DockingStationPipe station;
    private boolean isValid = false;

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftRobotics.robotStationItem)};
    }

    @Override
    public DockingStation getStation() {
        return this.station;
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    @Override
    public void invalidate() {
        if (this.station != null && this.station.getPipe() != null && !this.station.getPipe().getWorld().field_72995_K) {
            RobotManager.registryProvider.getRegistry(this.station.world).removeStation(this.station);
            this.isValid = false;
        }
    }

    @Override
    public void validate(IPipeTile pipe, ForgeDirection direction) {
        if (!this.isValid && !pipe.getWorld().field_72995_K) {
            this.station = (DockingStationPipe)RobotManager.registryProvider.getRegistry(pipe.getWorld()).getStation(pipe.x(), pipe.y(), pipe.z(), direction);
            if (this.station == null) {
                this.station = new DockingStationPipe(pipe, direction);
                RobotManager.registryProvider.getRegistry(pipe.getWorld()).registerStation(this.station);
            }
            this.isValid = true;
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private void refreshRenderState() {
        this.renderState = this.station.isTaken() ? (this.station.isMainStation() ? RobotStationState.Linked : RobotStationState.Reserved) : RobotStationState.Available;
    }

    public RobotStationState getRenderState() {
        if (this.renderState == null) {
            this.renderState = RobotStationState.None;
        }
        return this.renderState;
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return new RobotStationPluggableRenderer();
    }

    @Override
    public void writeData(ByteBuf data) {
        this.refreshRenderState();
        data.writeByte(this.getRenderState().ordinal());
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return this.getRenderState() != ((RobotStationPluggable)o).getRenderState();
    }

    @Override
    public void readData(ByteBuf data) {
        try {
            this.renderState = RobotStationState.values()[data.readUnsignedByte()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.renderState = RobotStationState.None;
        }
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        return new RobotStationPluggable();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.station != null && this.station.robotTaking() != null && this.station.robotTaking().getBattery() != null && this.station.robotTaking().getDockingStation() == this.station) {
            return ((EntityRobot)this.station.robotTaking()).receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        if (this.station == null) {
            info.add("RobotStationPluggable: No station found!");
        } else {
            this.refreshRenderState();
            info.add("Docking Station (side " + side.name() + ", " + this.getRenderState().name() + ")");
            if (this.station.robotTaking() != null && this.station.robotTaking() instanceof IDebuggable) {
                ((IDebuggable)((Object)this.station.robotTaking())).getDebugInfo(info, ForgeDirection.UNKNOWN, debugger, player);
            }
        }
    }

    public static enum RobotStationState {
        None,
        Available,
        Reserved,
        Linked;

    }

    public class RobotStationPluggableRenderer
    implements IPipePluggableRenderer {
        private float zFightOffset = 2.4414062E-4f;

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass != 0) {
                return;
            }
            RobotStationState state = ((RobotStationPluggable)pipePluggable).getRenderState();
            switch (state) {
                case None: 
                case Available: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStation.ordinal()));
                    break;
                }
                case Reserved: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationReserved.ordinal()));
                    break;
                }
                case Linked: {
                    blockStateMachine.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStationLinked.ordinal()));
                }
            }
            float[][] zeroState = new float[3][2];
            zeroState[0][0] = 0.4325f;
            zeroState[0][1] = 0.5675f;
            zeroState[1][0] = 0.0f;
            zeroState[1][1] = 0.1875f + this.zFightOffset;
            zeroState[2][0] = 0.4325f;
            zeroState[2][1] = 0.5675f;
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            zeroState[0][0] = 0.25f;
            zeroState[0][1] = 0.75f;
            zeroState[1][0] = 0.1875f;
            zeroState[1][1] = 0.25f + this.zFightOffset;
            zeroState[2][0] = 0.25f;
            zeroState[2][1] = 0.75f;
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }
    }
}

