/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerShears
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.getItem() instanceof ItemShears;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        IShearable shearableBlock;
        Block block = world.getBlock(x, y, z);
        if (block instanceof IShearable && (shearableBlock = (IShearable)block).isShearable(stack, (IBlockAccess)world, x, y, z)) {
            world.playSoundEffect((double)x, (double)y, (double)z, Block.soundTypeGrass.getBreakSound(), 1.0f, 1.0f);
            ArrayList drops = shearableBlock.onSheared(stack, (IBlockAccess)world, x, y, z, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)stack));
            world.setBlockToAir(x, y, z);
            if (stack.attemptDamageItem(1, player.getRNG())) {
                --stack.stackSize;
            }
            if (stack.stackSize > 0) {
                activator.sendItem(stack, direction.getOpposite());
            }
            for (ItemStack dropStack : drops) {
                activator.sendItem(dropStack, direction.getOpposite());
            }
            return true;
        }
        return false;
    }
}

