/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerDispenser
implements IStripesHandler {
    public static final List<Object> items = new ArrayList<Object>();

    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        if (items.contains(stack.getItem())) {
            return true;
        }
        for (Class<?> c = stack.getItem().getClass(); c != Item.class; c = c.getSuperclass()) {
            if (!items.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        Position origin = new Position(x, y, z, direction);
        origin.moveBackwards(1.0);
        Source source = new Source(world, (int)origin.x, (int)origin.y, (int)origin.z, direction);
        IBehaviorDispenseItem behaviour = (IBehaviorDispenseItem)BlockDispenser.dispenseBehaviorRegistry.getObject((Object)stack.getItem());
        if (behaviour != null) {
            ItemStack output = behaviour.dispense((IBlockSource)source, stack.copy());
            if (output.stackSize > 0) {
                activator.sendItem(output, direction.getOpposite());
            }
            return true;
        }
        return false;
    }

    public class Source
    implements IBlockSource {
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final ForgeDirection side;

        public Source(World world, int x, int y, int z, ForgeDirection side) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.side = side;
        }

        public double getX() {
            return (double)this.x + 0.5;
        }

        public double getY() {
            return (double)this.y + 0.5;
        }

        public double getZ() {
            return (double)this.z + 0.5;
        }

        public int getXInt() {
            return this.x;
        }

        public int getYInt() {
            return this.y;
        }

        public int getZInt() {
            return this.z;
        }

        public int getBlockMetadata() {
            return this.side.ordinal();
        }

        public TileEntity getBlockTileEntity() {
            return this.world.getTileEntity(this.x, this.y, this.z);
        }

        public World getWorld() {
            return this.world;
        }
    }
}

