/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.schematics;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.schematics.BptPipeExtension;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicPipe
extends SchematicTile {
    private BuildingPermission permission = BuildingPermission.ALL;

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.item == Item.getItemById((int)this.tileNBT.getInteger("pipeId"));
        }
        return false;
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        TileGenericPipe.SideProperties props = new TileGenericPipe.SideProperties();
        props.readFromNBT(this.tileNBT);
        props.rotateLeft();
        props.writeToNBT(this.tileNBT);
        Item pipeItem = Item.getItemById((int)this.tileNBT.getInteger("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).rotateLeft(this, context);
        }
        if (this.tileNBT.hasKey("Gate")) {
            NBTTagCompound gateNBT = this.tileNBT.getCompoundTag("Gate");
            this.rotateGateLeft(gateNBT);
        } else {
            int i;
            NBTTagCompound[] gatesNBT = new NBTTagCompound[6];
            for (i = 0; i < 6; ++i) {
                if (!this.tileNBT.hasKey("Gate[" + i + "]")) continue;
                gatesNBT[i] = this.tileNBT.getCompoundTag("Gate[" + i + "]");
            }
            for (i = 0; i < 6; ++i) {
                int newI = ForgeDirection.values()[i].getRotation(ForgeDirection.UP).ordinal();
                if (gatesNBT[i] != null) {
                    this.rotateGateLeft(gatesNBT[i]);
                    this.tileNBT.setTag("Gate[" + newI + "]", (NBTBase)gatesNBT[i]);
                    continue;
                }
                this.tileNBT.removeTag("Gate[" + newI + "]");
            }
        }
    }

    private void rotateGateLeft(NBTTagCompound gateNBT) {
        for (int i = 0; i < Gate.MAX_STATEMENTS; ++i) {
            if (gateNBT.hasKey("trigger[" + i + "]")) {
                IStatement t = StatementManager.statements.get(gateNBT.getString("trigger[" + i + "]"));
                t = t.rotateLeft();
                gateNBT.setString("trigger[" + i + "]", t.getUniqueTag());
            }
            if (gateNBT.hasKey("action[" + i + "]")) {
                IStatement a = StatementManager.statements.get(gateNBT.getString("action[" + i + "]"));
                a = a.rotateLeft();
                gateNBT.setString("action[" + i + "]", a.getUniqueTag());
            }
            for (int j = 0; j < Gate.MAX_PARAMETERS; ++j) {
                IStatementParameter parameter;
                NBTTagCompound cpt;
                if (gateNBT.hasKey("triggerParameters[" + i + "][" + j + "]")) {
                    cpt = gateNBT.getCompoundTag("triggerParameters[" + i + "][" + j + "]");
                    parameter = StatementManager.createParameter(cpt.getString("kind"));
                    parameter.readFromNBT(cpt);
                    parameter = parameter.rotateLeft();
                    parameter.writeToNBT(cpt);
                    gateNBT.setTag("triggerParameters[" + i + "][" + j + "]", (NBTBase)cpt);
                }
                if (!gateNBT.hasKey("actionParameters[" + i + "][" + j + "]")) continue;
                cpt = gateNBT.getCompoundTag("actionParameters[" + i + "][" + j + "]");
                parameter = StatementManager.createParameter(cpt.getString("kind"));
                parameter.readFromNBT(cpt);
                parameter = parameter.rotateLeft();
                parameter.writeToNBT(cpt);
                gateNBT.setTag("actionParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
        if (gateNBT.hasKey("direction")) {
            gateNBT.setInteger("direction", ForgeDirection.values()[gateNBT.getInteger("direction")].getRotation(ForgeDirection.UP).ordinal());
        }
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        this.tileNBT.setInteger("x", x);
        this.tileNBT.setInteger("y", y);
        this.tileNBT.setInteger("z", z);
        context.world().setBlock(x, y, z, this.block, this.meta, 3);
        TileEntity tile = context.world().getTileEntity(x, y, z);
        tile.readFromNBT(this.tileNBT);
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        TileEntity tile = context.world().getTileEntity(x, y, z);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            tile.writeToNBT(this.tileNBT);
            this.tileNBT.removeTag("travelingEntities");
            for (ForgeDirection direction : ForgeDirection.values()) {
                this.tileNBT.removeTag("tank[" + direction.ordinal() + "]");
                this.tileNBT.removeTag("transferState[" + direction.ordinal() + "]");
            }
            for (int i = 0; i < 6; ++i) {
                this.tileNBT.removeTag("powerQuery[" + i + "]");
                this.tileNBT.removeTag("nextPowerQuery[" + i + "]");
                this.tileNBT.removeTag("internalPower[" + i + "]");
                this.tileNBT.removeTag("internalNextPower[" + i + "]");
            }
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            ArrayList<ItemStack> items = pipe.computeItemDrop();
            this.storedRequirements = new ItemStack[items.size() + 1];
            items.toArray(this.storedRequirements);
            this.storedRequirements[this.storedRequirements.length - 1] = new ItemStack(pipe.item, 1, pipe.container.getItemMetadata());
        }
    }

    @Override
    public void postProcessing(IBuilderContext context, int x, int y, int z) {
        Item pipeItem = Item.getItemById((int)this.tileNBT.getInteger("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).postProcessing(this, context);
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        super.idsToBlueprint(registry);
        if (this.tileNBT.hasKey("pipeId")) {
            Item item = Item.getItemById((int)this.tileNBT.getInteger("pipeId"));
            this.tileNBT.setInteger("pipeId", registry.getIdForItem(item));
        }
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        super.idsToWorld(registry);
        if (this.tileNBT.hasKey("pipeId")) {
            try {
                Item item = registry.getItemForId(this.tileNBT.getInteger("pipeId"));
                this.tileNBT.setInteger("pipeId", Item.getIdFromItem((Item)item));
            }
            catch (MappingNotFoundException e) {
                this.tileNBT.removeTag("pipeId");
            }
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.setInteger("version", 2);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        if (!nbt.hasKey("version") || nbt.getInteger("version") < 2) {
            this.tileNBT.removeTag("items");
            if (this.tileNBT.hasKey("Gate")) {
                NBTTagCompound gateNBT = this.tileNBT.getCompoundTag("Gate");
                for (int i = 0; i < 8; ++i) {
                    NBTTagCompound parameterNBT;
                    if (!gateNBT.hasKey("triggerParameters[" + i + "]") || !(parameterNBT = gateNBT.getCompoundTag("triggerParameters[" + i + "]")).hasKey("stack")) continue;
                    parameterNBT.removeTag("stack");
                }
            }
        }
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.permission;
    }
}

