/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.transport.utils.TransportUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityPickupFX
extends EntityFX {
    private Entity entityToPickUp;
    private TileEntity entityPickingUp;
    private int age = 0;
    private int maxAge = 0;
    private double yOffs;

    public TileEntityPickupFX(World par1World, EntityItem par2Entity, TileEntity par3Entity) {
        super(par1World, par2Entity.posX, par2Entity.posY, par2Entity.posZ, par2Entity.motionX, par2Entity.motionY, par2Entity.motionZ);
        this.entityToPickUp = par2Entity;
        this.entityPickingUp = par3Entity;
        this.maxAge = 3;
        this.yOffs = TransportUtils.getPipeFloorOf(par2Entity.getEntityItem());
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float var8 = ((float)this.age + par2) / (float)this.maxAge;
        var8 *= var8;
        double var9 = this.entityToPickUp.posX;
        double var11 = this.entityToPickUp.posY;
        double var13 = this.entityToPickUp.posZ;
        double var15 = (double)this.entityPickingUp.xCoord + 0.5;
        double var17 = (double)this.entityPickingUp.yCoord + this.yOffs;
        double var19 = (double)this.entityPickingUp.zCoord + 0.5;
        double var21 = var9 + (var15 - var9) * (double)var8;
        double var23 = var11 + (var17 - var11) * (double)var8;
        double var25 = var13 + (var19 - var13) * (double)var8;
        int var30 = this.getBrightnessForRender(par2);
        int var31 = var30 % 65536;
        int var32 = var30 / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)var31 / 1.0f), (float)((float)var32 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var21 -= interpPosX;
        var23 -= interpPosY;
        var25 -= interpPosZ;
        if (RenderManager.instance.renderEngine != null) {
            RenderManager.instance.renderEntityWithPosYaw(this.entityToPickUp, var21, var23, var25, this.entityToPickUp.rotationYaw, par2);
        }
    }

    public void onUpdate() {
        ++this.age;
        if (this.age == this.maxAge) {
            this.setDead();
        }
    }

    public int getFXLayer() {
        return 3;
    }
}

