/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.RenderEntityBlock;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.render.PipeTransportFluidsRenderer;
import buildcraft.transport.render.PipeTransportPowerRenderer;
import buildcraft.transport.render.PipeTransportRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PipeRendererTESR
extends TileEntitySpecialRenderer {
    public static final PipeRendererTESR INSTANCE = new PipeRendererTESR();

    protected PipeRendererTESR() {
    }

    public void onTextureReload() {
        PipeTransportPowerRenderer.clear();
        PipeTransportFluidsRenderer.clear();
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        this.renderGatesWires(pipe, x, y, z);
        this.renderPluggables(pipe, x, y, z);
        PipeTransportRenderer renderer = PipeTransportRenderer.RENDERER_MAP.get(pipe.pipe.transport.getClass());
        if (renderer != null) {
            renderer.render(renderer.useServerTileIfPresent() ? (Pipe)((IPipeTile)CoreProxy.proxy.getServerTile(pipe)).getPipe() : pipe.pipe, x, y, z, f);
        }
    }

    private void renderGatesWires(TileGenericPipe pipe, double x, double y, double z) {
        PipeRenderState state = pipe.renderState;
        if (state.wireMatrix.hasWire(PipeWire.RED)) {
            this.pipeWireRender(pipe, 0.25f, 0.75f, 0.25f, PipeWire.RED, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.BLUE)) {
            this.pipeWireRender(pipe, 0.75f, 0.75f, 0.75f, PipeWire.BLUE, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.GREEN)) {
            this.pipeWireRender(pipe, 0.75f, 0.25f, 0.25f, PipeWire.GREEN, x, y, z);
        }
        if (state.wireMatrix.hasWire(PipeWire.YELLOW)) {
            this.pipeWireRender(pipe, 0.25f, 0.25f, 0.75f, PipeWire.YELLOW, x, y, z);
        }
    }

    private void pipeWireRender(TileGenericPipe pipe, float cx, float cy, float cz, PipeWire color, double x, double y, double z) {
        boolean isLit;
        PipeRenderState state = pipe.renderState;
        float minX = 0.25f;
        float minY = 0.25f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 0.75f;
        float maxZ = 0.75f;
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.WEST)) {
            minX = 0.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.EAST)) {
            maxX = 1.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.DOWN)) {
            minY = 0.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.UP)) {
            maxY = 1.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.NORTH)) {
            minZ = 0.0f;
            foundZ = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.SOUTH)) {
            maxZ = 1.0f;
            foundZ = true;
        }
        boolean center = false;
        if (minX == 0.0f && maxX != 1.0f && (foundY || foundZ)) {
            if (cx == 0.25f) {
                maxX = 0.25f;
            } else {
                center = true;
            }
        }
        if (minX != 0.0f && maxX == 1.0f && (foundY || foundZ)) {
            if (cx == 0.75f) {
                minX = 0.75f;
            } else {
                center = true;
            }
        }
        if (minY == 0.0f && maxY != 1.0f && (foundX || foundZ)) {
            if (cy == 0.25f) {
                maxY = 0.25f;
            } else {
                center = true;
            }
        }
        if (minY != 0.0f && maxY == 1.0f && (foundX || foundZ)) {
            if (cy == 0.75f) {
                minY = 0.75f;
            } else {
                center = true;
            }
        }
        if (minZ == 0.0f && maxZ != 1.0f && (foundX || foundY)) {
            if (cz == 0.25f) {
                maxZ = 0.25f;
            } else {
                center = true;
            }
        }
        if (minZ != 0.0f && maxZ == 1.0f && (foundX || foundY)) {
            if (cz == 0.75f) {
                minZ = 0.75f;
            } else {
                center = true;
            }
        }
        boolean found = foundX || foundY || foundZ;
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float scale = 1.001f;
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.bindTexture(TextureMap.locationBlocksTexture);
        RenderEntityBlock.RenderInfo renderBox = new RenderEntityBlock.RenderInfo();
        renderBox.texture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(color));
        boolean bl = isLit = (state.wireMatrix.getWireIconIndex(color) & 1) > 0;
        if (minZ != 0.25f || maxZ != 0.75f || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, minZ, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), maxZ);
            PipeRendererTESR.renderLitBox(renderBox, isLit);
        }
        if (minX != 0.25f || maxX != 0.75f || !found) {
            renderBox.setBounds(minX, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, maxX, cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            PipeRendererTESR.renderLitBox(renderBox, isLit);
        }
        if (minY != 0.25f || maxY != 0.75f || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, minY, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), maxY, cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            PipeRendererTESR.renderLitBox(renderBox, isLit);
        }
        if (center || !found) {
            renderBox.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            PipeRendererTESR.renderLitBox(renderBox, isLit);
        }
        GL11.glPopMatrix();
    }

    private void renderPluggables(TileGenericPipe pipe, double x, double y, double z) {
        TileEntityRendererDispatcher.instance.field_147553_e.bindTexture(TextureMap.locationBlocksTexture);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable pluggable = pipe.getPipePluggable(direction);
            if (pluggable == null || pluggable.getDynamicRenderer() == null) continue;
            pluggable.getDynamicRenderer().renderPluggable(pipe.getPipe(), direction, pluggable, x, y, z);
        }
    }

    public static void renderGateStatic(RenderBlocks renderblocks, ForgeDirection direction, GatePluggable gate, ITextureStates blockStateMachine, int x, int y, int z) {
        blockStateMachine.getTextureState().set(gate.getLogic().getGateIcon());
        float trim = 0.1f;
        float[][] zeroState = new float[3][2];
        float min = 0.25f + trim / 2.0f;
        float max = 0.75f - trim / 2.0f;
        zeroState[0][0] = min;
        zeroState[0][1] = max;
        zeroState[1][0] = 0.15f;
        zeroState[1][1] = 0.251f;
        zeroState[2][0] = min;
        zeroState[2][1] = max;
        float[][] rotated = MatrixTranformations.deepClone(zeroState);
        MatrixTranformations.transform(rotated, direction);
        blockStateMachine.setRenderAllSides();
        renderblocks.setRenderBounds((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
        renderblocks.renderStandardBlock(blockStateMachine.getBlock(), x, y, z);
    }

    public static void renderGate(double x, double y, double z, GatePluggable gate, ForgeDirection direction) {
        IIcon materialIcon;
        GL11.glPushMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        IIcon lightIcon = gate.isLit ? gate.getLogic().getIconLit() : gate.getLogic().getIconDark();
        float translateCenter = 0.0f;
        PipeRendererTESR.renderGate(lightIcon, 0, 0.1f, 0.0f, 0.0f, direction, gate.isLit, 1);
        float pulseStage = gate.getPulseStage() * 2.0f;
        if (gate.isPulsing || pulseStage != 0.0f) {
            IIcon gateIcon = gate.getLogic().getGateIcon();
            float amplitude = 0.1f;
            float start = 0.01f;
            translateCenter = pulseStage < 1.0f ? pulseStage * amplitude + start : amplitude - (pulseStage - 1.0f) * amplitude + start;
            PipeRendererTESR.renderGate(gateIcon, 0, 0.13f, translateCenter, translateCenter, direction, false, 2);
            PipeRendererTESR.renderGate(lightIcon, 0, 0.13f, translateCenter, translateCenter, direction, gate.isLit, 0);
        }
        if ((materialIcon = gate.getMaterial().getIconBlock()) != null) {
            PipeRendererTESR.renderGate(materialIcon, 1, 0.13f, translateCenter, translateCenter, direction, false, 1);
        }
        for (IGateExpansion expansion : gate.getExpansions()) {
            PipeRendererTESR.renderGate(expansion.getOverlayBlock(), 2, 0.13f, translateCenter, translateCenter, direction, false, 0);
        }
        GL11.glPopMatrix();
    }

    private static void renderGate(IIcon icon, int layer, float trim, float translateCenter, float extraDepth, ForgeDirection direction, boolean isLit, int sideRenderingMode) {
        RenderEntityBlock.RenderInfo renderBox = new RenderEntityBlock.RenderInfo();
        renderBox.texture = icon;
        float[][] zeroState = new float[3][2];
        float min = 0.25f + trim / 2.0f;
        float max = 0.75f - trim / 2.0f;
        zeroState[0][0] = min;
        zeroState[0][1] = max;
        zeroState[1][0] = 0.15f - 0.001f * (float)layer;
        zeroState[1][1] = 0.251f + 0.01f * (float)layer + extraDepth;
        zeroState[2][0] = min;
        zeroState[2][1] = max;
        if (translateCenter != 0.0f) {
            GL11.glPushMatrix();
            float xt = (float)direction.offsetX * translateCenter;
            float yt = (float)direction.offsetY * translateCenter;
            float zt = (float)direction.offsetZ * translateCenter;
            GL11.glTranslatef((float)xt, (float)yt, (float)zt);
        }
        float[][] rotated = MatrixTranformations.deepClone(zeroState);
        MatrixTranformations.transform(rotated, direction);
        switch (sideRenderingMode) {
            case 0: {
                renderBox.setRenderSingleSide(direction.ordinal());
                break;
            }
            case 1: {
                renderBox.setRenderSingleSide(direction.ordinal());
                renderBox.renderSide[direction.ordinal() ^ 1] = true;
                break;
            }
        }
        renderBox.setBounds(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
        PipeRendererTESR.renderLitBox(renderBox, isLit);
        if (translateCenter != 0.0f) {
            GL11.glPopMatrix();
        }
    }

    private static void renderLitBox(RenderEntityBlock.RenderInfo info, boolean isLit) {
        RenderEntityBlock.INSTANCE.renderBlock(info);
        float lastX = OpenGlHelper.lastBrightnessX;
        float lastY = OpenGlHelper.lastBrightnessY;
        if (isLit) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glDepthMask((boolean)true);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)61680.0f, (float)0.0f);
            RenderEntityBlock.INSTANCE.renderBlock(info);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)lastX, (float)lastY);
    }

    public boolean isOpenOrientation(PipeRenderState state, ForgeDirection direction) {
        int connections = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.pipeConnectionMatrix.isConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || connections == 0) {
            return false;
        }
        return targetOrientation.getOpposite() == direction;
    }
}

