/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.Pipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PipeLogicIron {
    protected final Pipe<?> pipe;
    private boolean lastPower = false;

    public PipeLogicIron(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    public void switchOnRedstone() {
        boolean currentPower = this.pipe.container.getWorldObj().isBlockIndirectlyGettingPowered(this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord);
        if (currentPower != this.lastPower) {
            this.switchPosition();
            this.lastPower = currentPower;
        }
    }

    private void switchPosition() {
        int meta = this.pipe.container.getBlockMetadata();
        for (int i = meta + 1; i <= meta + 6; ++i) {
            ForgeDirection facing = ForgeDirection.getOrientation((int)(i % 6));
            if (!this.setFacing(facing)) continue;
            return;
        }
    }

    private boolean isValidFacing(ForgeDirection side) {
        if (!this.pipe.container.isPipeConnected(side)) {
            return false;
        }
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidOutputTile(tile);
    }

    protected boolean isValidOutputTile(TileEntity tile) {
        return (!(tile instanceof IInventory) || ((IInventory)tile).getInventoryStackLimit() != 0) && this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        this.lastPower = this.pipe.container.getWorldObj().isBlockIndirectlyGettingPowered(this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord);
    }

    public void onBlockPlaced() {
        this.pipe.container.getWorldObj().setBlockMetadataWithNotify(this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord, 1, 3);
        this.switchPosition();
    }

    public boolean setFacing(ForgeDirection facing) {
        if (facing.ordinal() != this.pipe.container.getBlockMetadata() && this.isValidFacing(facing)) {
            this.pipe.container.getWorldObj().setBlockMetadataWithNotify(this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord, facing.ordinal(), 3);
            this.pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.blockActivated(entityplayer, ForgeDirection.UNKNOWN);
    }

    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        Item equipped;
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord)) {
            if (side == ForgeDirection.UNKNOWN) {
                this.switchPosition();
            } else {
                this.setFacing(side);
            }
            this.pipe.container.scheduleRenderUpdate();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.xCoord, this.pipe.container.yCoord, this.pipe.container.zCoord);
            return true;
        }
        return false;
    }

    public ForgeDirection getOutputDirection() {
        return ForgeDirection.getOrientation((int)this.pipe.container.getBlockMetadata());
    }

    public boolean outputOpen(ForgeDirection to) {
        return to.ordinal() == this.pipe.container.getBlockMetadata();
    }
}

