/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryWrapper;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.pipes.PipeItemsWood;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsEmerald
extends PipeItemsWood
implements ISerializable,
IGuiReturnHandler {
    private EmeraldPipeSettings settings = new EmeraldPipeSettings();
    private final SimpleInventory filters = new SimpleInventory(9, "Filters", 1);
    private int currentFilter = 0;

    public PipeItemsEmerald(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeItemsEmerald_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmerald_Solid.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        if (entityplayer.getCurrentEquippedItem() != null && Block.getBlockFromItem((Item)entityplayer.getCurrentEquippedItem().getItem()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer, side)) {
            return true;
        }
        if (!this.container.getWorldObj().isRemote) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 52, this.container.getWorldObj(), this.container.xCoord, this.container.yCoord, this.container.zCoord);
        }
        return true;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory == null) {
            return null;
        }
        ISidedInventory sidedInventory = InventoryWrapper.getWrappedInventory(InvUtils.getInventory(inventory));
        if (this.settings.getFilterMode() == FilterMode.ROUND_ROBIN) {
            return this.checkExtractRoundRobin(sidedInventory, doRemove, from);
        }
        return this.checkExtractFiltered(sidedInventory, doRemove, from);
    }

    private ItemStack[] checkExtractFiltered(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int k : inventory.getAccessibleSlotsFromSide(from.ordinal())) {
            boolean isBlackList;
            ItemStack stack = inventory.getStackInSlot(k);
            if (stack == null || stack.stackSize <= 0 || !inventory.canExtractItem(k, stack, from.ordinal())) continue;
            boolean matches = this.isFiltered(stack);
            boolean bl = isBlackList = this.settings.getFilterMode() == FilterMode.BLACK_LIST;
            if (isBlackList && matches || !isBlackList && !matches) continue;
            if (doRemove) {
                int maxStackSize = stack.stackSize;
                int stackSize = Math.min(maxStackSize, this.battery.getEnergyStored() / 10);
                if (stackSize > 0) {
                    this.speedMultiplier = Math.min(4.0f, (float)(this.battery.getEnergyStored() * 10 / stackSize));
                    int energyUsed = (int)((float)(stackSize * 10) * this.speedMultiplier);
                    this.battery.useEnergy(energyUsed, energyUsed, false);
                    stack = inventory.decrStackSize(k, stackSize);
                } else {
                    return null;
                }
            }
            return new ItemStack[]{stack};
        }
        return null;
    }

    private ItemStack[] checkExtractRoundRobin(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.getAccessibleSlotsFromSide(from.ordinal())) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.stackSize <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!StackHelper.isMatchingItemOrList(filter, stack) || !inventory.canExtractItem(i, stack, from.ordinal())) continue;
            if (doRemove) {
                stack = inventory.decrStackSize(i, 1);
                this.incrementFilter();
            } else {
                stack = stack.copy();
                stack.stackSize = 1;
            }
            return new ItemStack[]{stack};
        }
        return null;
    }

    private boolean isFiltered(ItemStack stack) {
        for (int i = 0; i < this.filters.getSizeInventory(); ++i) {
            ItemStack filter = this.filters.getStackInSlot(i);
            if (filter == null) {
                return false;
            }
            if (!StackHelper.isMatchingItemOrList(filter, stack)) continue;
            return true;
        }
        return false;
    }

    private void incrementFilter() {
        this.currentFilter = (this.currentFilter + 1) % this.filters.getSizeInventory();
        for (int count = 0; this.filters.getStackInSlot(this.currentFilter) == null && count < this.filters.getSizeInventory(); ++count) {
            this.currentFilter = (this.currentFilter + 1) % this.filters.getSizeInventory();
        }
    }

    private ItemStack getCurrentFilter() {
        ItemStack filter = this.filters.getStackInSlot(this.currentFilter);
        if (filter == null) {
            this.incrementFilter();
        }
        return this.filters.getStackInSlot(this.currentFilter);
    }

    public IInventory getFilters() {
        return this.filters;
    }

    public EmeraldPipeSettings getSettings() {
        return this.settings;
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.filters.writeToNBT(nbt);
        this.settings.writeToNBT(nbt);
        NetworkUtils.writeNBT(data, nbt);
        data.writeByte(this.currentFilter);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT(data);
        this.filters.readFromNBT(nbt);
        this.settings.readFromNBT(nbt);
        this.currentFilter = data.readUnsignedByte();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.settings.readFromNBT(nbt);
        this.currentFilter = nbt.getInteger("currentFilter") % this.filters.getSizeInventory();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        this.settings.writeToNBT(nbt);
        nbt.setInteger("currentFilter", this.currentFilter);
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        data.writeByte((int)((byte)this.settings.getFilterMode().ordinal()));
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        this.settings.setFilterMode(FilterMode.values()[data.readByte()]);
    }

    public class EmeraldPipeSettings {
        private FilterMode filterMode = FilterMode.WHITE_LIST;

        public FilterMode getFilterMode() {
            return this.filterMode;
        }

        public void setFilterMode(FilterMode mode) {
            this.filterMode = mode;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.filterMode = FilterMode.values()[nbt.getByte("filterMode")];
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.setByte("filterMode", (byte)this.filterMode.ordinal());
        }
    }

    public static enum FilterMode {
        WHITE_LIST,
        BLACK_LIST,
        ROUND_ROBIN;

    }
}

