/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.network.PacketCoordinates;
import buildcraft.core.lib.utils.BitSetUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.utils.FluidRenderData;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketFluidUpdate
extends PacketCoordinates {
    public FluidRenderData renderCache = new FluidRenderData();
    public BitSet delta;
    private boolean largeFluidCapacity;

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord) {
        super(3, xCoord, yCoord, zCoord);
    }

    public PacketFluidUpdate(int xCoord, int yCoord, int zCoord, boolean chunkPacket, boolean largeFluidCapacity) {
        super(3, xCoord, yCoord, zCoord);
        this.isChunkDataPacket = chunkPacket;
        this.largeFluidCapacity = largeFluidCapacity;
    }

    public PacketFluidUpdate() {
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        World world = CoreProxy.proxy.getClientWorld();
        if (!world.blockExists(this.posX, this.posY, this.posZ)) {
            return;
        }
        TileEntity entity = world.getTileEntity(this.posX, this.posY, this.posZ);
        if (!(entity instanceof IPipeTile)) {
            return;
        }
        IPipeTile pipeTile = (IPipeTile)entity;
        if (!(pipeTile.getPipe() instanceof Pipe)) {
            return;
        }
        Pipe pipe = (Pipe)pipeTile.getPipe();
        if (!(pipe.transport instanceof PipeTransportFluids)) {
            return;
        }
        PipeTransportFluids transLiq = (PipeTransportFluids)pipe.transport;
        this.largeFluidCapacity = transLiq.getCapacity() > 255;
        this.renderCache = transLiq.renderCache;
        byte[] dBytes = new byte[1];
        data.readBytes(dBytes);
        this.delta = BitSetUtils.fromByteArray(dBytes);
        if (this.delta.get(0)) {
            this.renderCache.fluidID = data.readShort();
            this.renderCache.color = this.renderCache.fluidID != 0 ? data.readInt() : 0xFFFFFF;
            this.renderCache.flags = this.renderCache.fluidID != 0 ? data.readUnsignedByte() : (short)0;
        }
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!this.delta.get(dir.ordinal() + 1)) continue;
            this.renderCache.amount[dir.ordinal()] = Math.min(transLiq.getCapacity(), this.largeFluidCapacity ? data.readUnsignedShort() : (int)data.readUnsignedByte());
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        byte[] dBytes = BitSetUtils.toByteArray(this.delta, 1);
        data.writeBytes(dBytes);
        if (this.delta.get(0)) {
            data.writeShort(this.renderCache.fluidID);
            if (this.renderCache.fluidID != 0) {
                data.writeInt(this.renderCache.color);
                data.writeByte(this.renderCache.flags);
            }
        }
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!this.delta.get(dir.ordinal() + 1)) continue;
            if (this.largeFluidCapacity) {
                data.writeShort(this.renderCache.amount[dir.ordinal()]);
                continue;
            }
            data.writeByte(this.renderCache.amount[dir.ordinal()]);
        }
    }

    @Override
    public int getID() {
        return 3;
    }
}

