/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.IPipe;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Gate;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gui.GuiGateInterface;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerGateInterface
extends BuildCraftContainer
implements ICommandReceiver {
    public ActionActiveState[] actionsState = new ActionActiveState[8];
    public GuiGateInterface gateCallback;
    IInventory playerIInventory;
    private final IPipe pipe;
    private Gate gate;
    private final NavigableSet<IStatement> potentialTriggers = new TreeSet<IStatement>(new Comparator<IStatement>(){

        @Override
        public int compare(IStatement o1, IStatement o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private final NavigableSet<IStatement> potentialActions = new TreeSet<IStatement>(new Comparator<IStatement>(){

        @Override
        public int compare(IStatement o1, IStatement o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;
    private int lastTriggerState = 0;

    public ContainerGateInterface(IInventory playerInventory, IPipe pipe) {
        super(0);
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = ActionActiveState.Deactivated;
        }
        this.pipe = pipe;
        this.playerIInventory = playerInventory;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot(this.playerIInventory, x + y * 9 + 9, 8 + x * 18, 0));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlotToContainer(new Slot(this.playerIInventory, x, 8 + x * 18, 0));
        }
    }

    public void init() {
        if (this.gate == null) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.getSlot((int)(x + y * 9)).yDisplayPosition = this.gate.material.guiHeight - 84 + y * 18;
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.getSlot((int)(x + 27)).yDisplayPosition = this.gate.material.guiHeight - 26;
        }
        if (!this.pipe.getTile().getWorld().isRemote) {
            this.potentialTriggers.addAll(this.gate.getAllValidTriggers());
            this.potentialActions.addAll(this.gate.getAllValidActions());
            Iterator<IStatement> it = this.potentialTriggers.iterator();
            while (it.hasNext()) {
                IStatement trigger = it.next();
                if (trigger.minParameters() <= this.gate.material.numTriggerParameters) continue;
                it.remove();
            }
            it = this.potentialActions.iterator();
            while (it.hasNext()) {
                IStatement action = it.next();
                if (action.minParameters() <= this.gate.material.numActionParameters) continue;
                it.remove();
            }
        }
        if (this.gateCallback != null) {
            this.gateCallback.setGate(this.gate);
        }
    }

    private static String[] statementsToStrings(Collection<IStatement> statements) {
        int size = statements.size();
        String[] array = new String[size];
        int pos = 0;
        for (IStatement statement : statements) {
            array[pos++] = statement.getUniqueTag();
        }
        return array;
    }

    private static void stringsToStatements(Collection<IStatement> statements, String[] strings) {
        statements.clear();
        for (String id : strings) {
            statements.add(StatementManager.statements.get(id));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.gate != null;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void synchronize() {
        if (!this.isNetInitialized && this.pipe.getTile().getWorld().isRemote) {
            this.isNetInitialized = true;
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "initRequest", null));
        }
        if (!this.isSynchronized && this.pipe.getTile().getWorld().isRemote && this.gate != null) {
            this.isSynchronized = true;
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "selectionRequest", null));
        }
    }

    public void updateProgressBar(int id, int state) {
        if (id == 0) {
            for (int i = 0; i < 8; ++i) {
                this.actionsState[i] = ActionActiveState.values()[state >> i * 2 & 3];
            }
        }
    }

    private int calculateTriggerState() {
        if (this.gate == null) {
            return 0;
        }
        int state = 0;
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = this.getActionState(i);
            state |= (this.actionsState[i].ordinal() & 3) << i * 2;
        }
        return state;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        int state = this.calculateTriggerState();
        if (state != this.lastTriggerState) {
            for (Object crafter : this.crafters) {
                ICrafting viewingPlayer = (ICrafting)crafter;
                viewingPlayer.sendProgressBarUpdate((Container)this, 0, state);
            }
            this.lastTriggerState = state;
        }
    }

    public boolean hasTriggers() {
        return this.potentialTriggers.size() > 0;
    }

    public IStatement getFirstTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialTriggers.first();
    }

    public IStatement getLastTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialTriggers.last();
    }

    public Iterator<IStatement> getTriggerIterator(boolean descending) {
        return descending ? this.potentialTriggers.descendingIterator() : this.potentialTriggers.iterator();
    }

    public ActionActiveState getActionState(int i) {
        if (this.gate == null) {
            return ActionActiveState.Deactivated;
        }
        return this.gate.actionsState[i];
    }

    public IStatementParameter getTriggerParameter(int trigger, int param) {
        if (this.gate == null) {
            return null;
        }
        return this.gate.getTriggerParameter(trigger, param);
    }

    public boolean hasActions() {
        return !this.potentialActions.isEmpty();
    }

    public IStatement getFirstAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialActions.first();
    }

    public IStatement getLastAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IStatement)this.potentialActions.last();
    }

    public Iterator<IStatement> getActionIterator(boolean descending) {
        return descending ? this.potentialActions.descendingIterator() : this.potentialActions.iterator();
    }

    public Packet getStatementPacket(String name, final int slot, IStatement statement) {
        final String statementKind = statement != null ? statement.getUniqueTag() : null;
        return new PacketCommand(this, name, new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(slot);
                NetworkUtils.writeUTF(data, statementKind);
            }
        });
    }

    public Packet getStatementParameterPacket(String name, final int slot, final int paramSlot, IStatementParameter parameter) {
        final String parameterName = parameter != null ? parameter.getUniqueTag() : null;
        final NBTTagCompound parameterNBT = new NBTTagCompound();
        if (parameter != null) {
            parameter.writeToNBT(parameterNBT);
        }
        return new PacketCommand(this, name, new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(slot);
                data.writeByte(paramSlot);
                NetworkUtils.writeUTF(data, parameterName);
                NetworkUtils.writeNBT(data, parameterNBT);
            }
        });
    }

    public void setGate(int direction) {
        this.gate = (Gate)this.pipe.getGate(ForgeDirection.getOrientation((int)direction));
        this.init();
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer()) {
            EntityPlayer player = (EntityPlayer)sender;
            if ("initRequest".equals(command)) {
                final String[] triggerStrings = ContainerGateInterface.statementsToStrings(this.potentialTriggers);
                final String[] actionStrings = ContainerGateInterface.statementsToStrings(this.potentialActions);
                BuildCraftCore.instance.sendToPlayer(player, new PacketCommand(this, "init", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        data.writeByte(ContainerGateInterface.this.gate.getDirection().ordinal());
                        data.writeShort(triggerStrings.length);
                        data.writeShort(actionStrings.length);
                        for (String trigger : triggerStrings) {
                            NetworkUtils.writeUTF(data, trigger);
                        }
                        for (String action : actionStrings) {
                            NetworkUtils.writeUTF(data, action);
                        }
                    }
                }));
            } else if ("selectionRequest".equals(command)) {
                for (int position = 0; position < this.gate.material.numSlots; ++position) {
                    IStatement action = this.gate.getAction(position);
                    IStatement trigger = this.gate.getTrigger(position);
                    BuildCraftCore.instance.sendToPlayer(player, this.getStatementPacket("setAction", position, action));
                    BuildCraftCore.instance.sendToPlayer(player, this.getStatementPacket("setTrigger", position, trigger));
                    for (int p = 0; p < this.gate.material.numActionParameters; ++p) {
                        BuildCraftCore.instance.sendToPlayer(player, this.getStatementParameterPacket("setActionParameter", position, p, this.gate.getActionParameter(position, p)));
                    }
                    for (int q = 0; q < this.gate.material.numTriggerParameters; ++q) {
                        BuildCraftCore.instance.sendToPlayer(player, this.getStatementParameterPacket("setTriggerParameter", position, q, this.gate.getTriggerParameter(position, q)));
                    }
                }
            }
        } else if (side.isClient() && "init".equals(command)) {
            int i;
            this.setGate(stream.readByte());
            String[] triggerStrings = new String[stream.readShort()];
            String[] actionStrings = new String[stream.readShort()];
            for (i = 0; i < triggerStrings.length; ++i) {
                triggerStrings[i] = NetworkUtils.readUTF(stream);
            }
            for (i = 0; i < actionStrings.length; ++i) {
                actionStrings[i] = NetworkUtils.readUTF(stream);
            }
            ContainerGateInterface.stringsToStatements(this.potentialTriggers, triggerStrings);
            ContainerGateInterface.stringsToStatements(this.potentialActions, actionStrings);
        }
        if ("setAction".equals(command)) {
            this.setAction(stream.readUnsignedByte(), NetworkUtils.readUTF(stream), false);
        } else if ("setTrigger".equals(command)) {
            this.setTrigger(stream.readUnsignedByte(), NetworkUtils.readUTF(stream), false);
        } else if ("setActionParameter".equals(command) || "setTriggerParameter".equals(command)) {
            short slot = stream.readUnsignedByte();
            short param = stream.readUnsignedByte();
            String parameterName = NetworkUtils.readUTF(stream);
            NBTTagCompound parameterData = NetworkUtils.readNBT(stream);
            IStatementParameter parameter = null;
            if (parameterName != null && parameterName.length() > 0) {
                parameter = StatementManager.createParameter(parameterName);
            }
            if (parameter != null) {
                parameter.readFromNBT(parameterData);
                if ("setActionParameter".equals(command)) {
                    this.setActionParameter(slot, param, parameter, false);
                } else {
                    this.setTriggerParameter(slot, param, parameter, false);
                }
            }
        }
    }

    public void setAction(int action, String tag, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        IStatement statement = null;
        if (tag != null && tag.length() > 0) {
            statement = StatementManager.statements.get(tag);
        }
        this.gate.setAction(action, statement);
        if (this.pipe.getTile().getWorld().isRemote && notifyServer) {
            BuildCraftCore.instance.sendToServer(this.getStatementPacket("setAction", action, statement));
        }
    }

    public void setTrigger(int trigger, String tag, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        IStatement statement = null;
        if (tag != null && tag.length() > 0) {
            statement = StatementManager.statements.get(tag);
        }
        this.gate.setTrigger(trigger, statement);
        if (this.pipe.getTile().getWorld().isRemote && notifyServer) {
            BuildCraftCore.instance.sendToServer(this.getStatementPacket("setTrigger", trigger, statement));
        }
    }

    public void setActionParameter(int action, int param, IStatementParameter parameter, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        this.gate.setActionParameter(action, param, parameter);
        if (this.pipe.getTile().getWorld().isRemote && notifyServer) {
            BuildCraftCore.instance.sendToServer(this.getStatementParameterPacket("setActionParameter", action, param, parameter));
        }
    }

    public void setTriggerParameter(int trigger, int param, IStatementParameter parameter, boolean notifyServer) {
        if (this.gate == null) {
            return;
        }
        this.gate.setTriggerParameter(trigger, param, parameter);
        if (this.pipe.getTile().getWorld().isRemote && notifyServer) {
            BuildCraftCore.instance.sendToServer(this.getStatementParameterPacket("setTriggerParameter", trigger, param, parameter));
        }
    }

    public ResourceLocation getGateGuiFile() {
        return this.gate.material.guiFile;
    }

    public String getGateName() {
        return GateDefinition.getLocalizedName(this.gate.material, this.gate.logic);
    }
}

