/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.transport.ItemPipe;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class PipeColoringRecipe
implements IRecipe {
    private ItemStack getResult(InventoryCrafting crafting) {
        ItemStack oneColorPipeStack = null;
        ItemStack pipeStack = null;
        boolean hasDifferentPipes = false;
        boolean isBleach = false;
        ItemStack dye = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = crafting.getStackInSlot(i);
            if (stack == null || stack.getItem() == null || stack.stackSize == 0) continue;
            if (stack.getItem() instanceof ItemPipe) {
                if (pipeStack == null) {
                    pipeStack = new ItemStack(stack.getItem(), 1, 0);
                    oneColorPipeStack = new ItemStack(stack.getItem(), 1, stack.getItemDamage());
                    continue;
                }
                if (stack.getItem() == pipeStack.getItem()) {
                    ++pipeStack.stackSize;
                    if (oneColorPipeStack.getItemDamage() != oneColorPipeStack.getItemDamage()) continue;
                    ++oneColorPipeStack.stackSize;
                    continue;
                }
                hasDifferentPipes = true;
                continue;
            }
            if (stack.getItem() == Items.water_bucket) {
                isBleach = true;
                continue;
            }
            if (!ColorUtils.isDye(stack)) continue;
            dye = stack;
        }
        if (isBleach && dye != null) {
            return null;
        }
        if (pipeStack != null && (isBleach || dye != null && pipeStack.stackSize == 8) && !hasDifferentPipes) {
            ItemStack result = pipeStack;
            if (dye != null) {
                result.setItemDamage(ColorUtils.getColorIDFromDye(dye) + 1);
            }
            return result;
        }
        return null;
    }

    public boolean matches(InventoryCrafting crafting, World world) {
        return this.getResult(crafting) != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting crafting) {
        return this.getResult(crafting);
    }

    public int getRecipeSize() {
        return 10;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

