/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeToolTipManager;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class ItemPipe
extends ItemBuildCraft
implements IItemPipe {
    @SideOnly(value=Side.CLIENT)
    private IIconProvider iconProvider;
    private int pipeIconIndex;

    protected ItemPipe(BCCreativeTab creativeTab) {
        super(creativeTab);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int sideI, float par8, float par9, float par10) {
        int side = sideI;
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        int i = x;
        int j = y;
        int k = z;
        Block worldBlock = world.getBlock(i, j, k);
        if (worldBlock == Blocks.snow) {
            side = 1;
        } else if (!(worldBlock == Blocks.vine || worldBlock == Blocks.tallgrass || worldBlock == Blocks.deadbush || worldBlock != null && worldBlock.isReplaceable((IBlockAccess)world, i, j, k))) {
            if (side == 0) {
                --j;
            }
            if (side == 1) {
                ++j;
            }
            if (side == 2) {
                --k;
            }
            if (side == 3) {
                ++k;
            }
            if (side == 4) {
                --i;
            }
            if (side == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (world.canPlaceEntityOnSide((Block)block, i, j, k, false, side, (Entity)entityplayer, itemstack)) {
            Pipe<?> pipe = BlockGenericPipe.createPipe(this);
            if (pipe == null) {
                BCLog.logger.log(Level.WARN, "Pipe failed to create during placement at {0},{1},{2}", new Object[]{i, j, k});
                return false;
            }
            if (BlockGenericPipe.placePipe(pipe, world, i, j, k, (Block)block, 0, entityplayer, ForgeDirection.getOrientation((int)sideI))) {
                block.onBlockPlacedBy(world, i, j, k, (EntityLivingBase)entityplayer, itemstack);
                if (!world.isRemote) {
                    TileEntity tile = world.getTileEntity(i, j, k);
                    ((TileGenericPipe)tile).initializeFromItemMetadata(itemstack.getItemDamage());
                }
                world.playSoundEffect((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), ((Block)block).stepSound.func_150496_b(), (((Block)block).stepSound.getVolume() + 1.0f) / 2.0f, ((Block)block).stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPipesIcons(IIconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public void setPipeIconIndex(int index) {
        this.pipeIconIndex = index;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        if (this.iconProvider != null) {
            return this.iconProvider.getIcon(this.pipeIconIndex);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.addInformation(stack, player, list, advanced);
        if (stack.getItemDamage() >= 1) {
            int color = stack.getItemDamage() - 1 & 0xF;
            list.add(ColorUtils.getFormattingTooltip(color) + EnumChatFormatting.ITALIC + StringUtils.localize("color." + ColorUtils.getName(color)));
        }
        Class<? extends Pipe<?>> pipe = BlockGenericPipe.pipes.get(this);
        List<String> toolTip = PipeToolTipManager.getToolTip(pipe, advanced);
        list.addAll(toolTip);
    }
}

