/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.silicon.TileProgrammingTable;
import buildcraft.silicon.gui.ContainerProgrammingTable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiProgrammingTable
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftsilicon:textures/gui/programming_table.png");
    private final TileProgrammingTable table;

    public GuiProgrammingTable(IInventory playerInventory, TileProgrammingTable programmingTable) {
        super(new ContainerProgrammingTable(playerInventory, programmingTable), programmingTable, TEXTURE);
        this.table = programmingTable;
        this.xSize = 176;
        this.ySize = 207;
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 6; ++i) {
                this.slots.add(new RecipeSlot(43 + 18 * i, 36 + 18 * j, j * 6 + i));
            }
        }
        this.updateRecipes();
    }

    public void updateRecipes() {
        if (this.table.options != null) {
            Iterator<ItemStack> cur = this.table.options.iterator();
            for (AdvancedSlot s : this.slots) {
                if (cur.hasNext()) {
                    ((RecipeSlot)s).slot = cur.next();
                    continue;
                }
                ((RecipeSlot)s).slot = null;
            }
        } else {
            for (AdvancedSlot s : this.slots) {
                ((RecipeSlot)s).slot = null;
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        String title = StringUtils.localize("tile.programmingTableBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 15, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 97, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.updateRecipes();
        int i = 0;
        for (AdvancedSlot slot2 : this.slots) {
            RecipeSlot slot = (RecipeSlot)slot2;
            if (slot.slot != null && this.table.optionId == i) {
                this.drawTexturedModalRect(this.guiLeft + slot.x, this.guiTop + slot.y, 196, 1, 16, 16);
            }
            ++i;
        }
        int h = this.table.getProgressScaled(70);
        this.drawTexturedModalRect(this.guiLeft + 164, this.guiTop + 36 + 70 - h, 176, 18, 4, h);
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void slotClicked(AdvancedSlot aslot, int mouseButton) {
        super.slotClicked(aslot, mouseButton);
        if (aslot instanceof RecipeSlot) {
            RecipeSlot slot = (RecipeSlot)aslot;
            if (slot.slot == null) {
                return;
            }
            if (this.table.optionId == slot.id) {
                this.table.rpcSelectOption(-1);
            } else {
                this.table.rpcSelectOption(slot.id);
            }
        }
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new LaserTableLedger());
        }
    }

    class RecipeSlot
    extends AdvancedSlot {
        public ItemStack slot;
        public int id;

        public RecipeSlot(int x, int y, int i) {
            super(GuiProgrammingTable.this, x, y);
            this.id = i;
        }

        @Override
        public ItemStack getItemStack() {
            return this.slot;
        }
    }

    private class LaserTableLedger
    extends GuiBuildCraft.Ledger {
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public LaserTableLedger() {
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiProgrammingTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiProgrammingTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyCurrentRequired") + ":", x + 22, y + 20, this.subheaderColour);
            GuiProgrammingTable.this.fontRendererObj.drawString(String.format("%d RF", ((GuiProgrammingTable)GuiProgrammingTable.this).table.clientRequiredEnergy), x + 22, y + 32, this.textColour);
            GuiProgrammingTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiProgrammingTable.this.fontRendererObj.drawString(String.format("%d RF", GuiProgrammingTable.this.table.getEnergy()), x + 22, y + 56, this.textColour);
            GuiProgrammingTable.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.assemblyRate") + ":", x + 22, y + 68, this.subheaderColour);
            GuiProgrammingTable.this.fontRendererObj.drawString(String.format("%.1f RF/t", Float.valueOf((float)GuiProgrammingTable.this.table.getRecentEnergyAverage() / 100.0f)), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%.1f RF/t", Float.valueOf((float)GuiProgrammingTable.this.table.getRecentEnergyAverage() / 100.0f));
        }
    }
}

