/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.gui.ContainerDummy;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.CraftingUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.ItemPackage;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public class TileStampingTable
extends TileLaserTableBase
implements IHasWork,
ISidedInventory {
    private static final int[] SLOTS = Utils.createSlotArray(0, 5);
    private SlotCrafting craftSlot;
    private final LocalInventoryCrafting crafting = new LocalInventoryCrafting();

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord);
    }

    private void handleLeftoverItems(IInventory items) {
        for (int i = 0; i < items.getSizeInventory(); ++i) {
            if (items.getStackInSlot(i) == null) continue;
            ItemStack output = items.getStackInSlot(i);
            if (output.stackSize <= 0) {
                items.setInventorySlotContents(i, null);
                continue;
            }
            boolean inserted = false;
            for (int j = 2; j <= 4; ++j) {
                ItemStack target = this.getStackInSlot(j);
                if (target == null || target.stackSize <= 0) {
                    this.setInventorySlotContents(j, output);
                    inserted = true;
                    break;
                }
                output.stackSize -= StackHelper.mergeStacks(output, target, true);
                if (output.stackSize != 0) continue;
                inserted = true;
                break;
            }
            if (!inserted && output.stackSize > 0) {
                output.stackSize -= Utils.addToRandomInventoryAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, output);
                if (output.stackSize > 0) {
                    InvUtils.dropItems(this.worldObj, output, this.xCoord, this.yCoord + 1, this.zCoord);
                }
            }
            items.setInventorySlotContents(i, null);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.getEnergy() >= this.getRequiredEnergy() && this.getEnergy() > 0) {
            IRecipe recipe;
            int i;
            ItemStack input = this.getStackInSlot(0);
            if (input == null) {
                return;
            }
            EntityPlayer internalPlayer = (EntityPlayer)this.getInternalPlayer().get();
            if (this.craftSlot == null) {
                this.craftSlot = new SlotCrafting(internalPlayer, (IInventory)this.crafting, (IInventory)this, 1, 0, 0);
            }
            if (input.getItem() instanceof ItemPackage) {
                NBTTagCompound tag = NBTUtils.getItemData(input);
                for (i = 0; i < 9; ++i) {
                    if (tag.hasKey("item" + i)) {
                        ItemStack is = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("item" + i));
                        if (is != null) {
                            this.crafting.setInventorySlotContents(i, is);
                            continue;
                        }
                        return;
                    }
                    this.crafting.setInventorySlotContents(i, null);
                }
            } else {
                ItemStack input2 = input.copy();
                input2.stackSize = 1;
                this.crafting.setInventorySlotContents(0, input2);
                for (i = 1; i < 9; ++i) {
                    this.crafting.setInventorySlotContents(i, null);
                }
            }
            ItemStack result = (recipe = this.crafting.findRecipe()) != null ? recipe.getCraftingResult((InventoryCrafting)this.crafting).copy() : null;
            this.addEnergy(-this.getRequiredEnergy());
            if (result != null) {
                this.craftSlot.onPickupFromSlot(internalPlayer, result);
                this.handleLeftoverItems((IInventory)this.crafting);
                this.handleLeftoverItems((IInventory)internalPlayer.inventory);
                for (int i2 = 1; i2 <= 4; ++i2) {
                    ItemStack inside = this.inv.getStackInSlot(i2);
                    if (inside == null || inside.stackSize <= 0) {
                        this.inv.setInventorySlotContents(i2, result.copy());
                        result.stackSize = 0;
                        break;
                    }
                    if (!StackHelper.canStacksMerge(inside, result)) continue;
                    result.stackSize -= StackHelper.mergeStacks(result, inside, true);
                    if (result.stackSize == 0) break;
                }
                if (result.stackSize > 0) {
                    EntityItem entityitem = new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.7, (double)this.zCoord + 0.5, result.copy());
                    this.worldObj.spawnEntityInWorld((Entity)entityitem);
                    result.stackSize = 0;
                }
                this.decrStackSize(0, 1);
            } else {
                ItemStack outputSlot = this.getStackInSlot(1);
                if (outputSlot == null) {
                    this.setInventorySlotContents(1, this.getStackInSlot(0));
                    this.setInventorySlotContents(0, null);
                }
            }
        }
    }

    @Override
    public int getRequiredEnergy() {
        ItemStack stack = this.getStackInSlot(0);
        ItemStack output = this.getStackInSlot(1);
        if (output != null && output.stackSize == output.getMaxStackSize()) {
            return 0;
        }
        if (stack != null && stack.getItem() != null) {
            if (stack.getItem() instanceof ItemPackage) {
                return 400 * NBTUtils.getItemData(stack).func_150296_c().size();
            }
            return 400;
        }
        return 0;
    }

    @Override
    public boolean hasWork() {
        return this.getRequiredEnergy() > 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public int getSizeInventory() {
        return 5;
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.stampingTableBlock.name");
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot >= 1;
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super((Container)new ContainerDummy(), 3, 3);
        }

        private IRecipe findRecipe() {
            return CraftingUtils.findMatchingRecipe(this, TileStampingTable.this.worldObj);
        }
    }
}

