/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class TileIntegrationTable
extends TileLaserTableBase
implements ISidedInventory {
    public static final int SLOT_OUTPUT = 9;
    private static final int CYCLE_LENGTH = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);
    public final IInventory clientOutputInv = new SimpleInventory(1, "Preview", 64);
    private int tick = 0;
    private IIntegrationRecipe activeRecipe;
    private boolean activeRecipeValid = false;
    private int maxExpCountClient;

    @Override
    public void initialize() {
        super.initialize();
        this.updateRecipe();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.activeRecipe == null || !this.activeRecipeValid) {
            this.setEnergy(0);
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        this.updateRecipeOutput();
        ItemStack output = this.clientOutputInv.getStackInSlot(0);
        if (!this.isRoomForOutput(output)) {
            this.setEnergy(0);
            return;
        }
        if (this.getEnergy() >= this.activeRecipe.getEnergyCost()) {
            this.setEnergy(0);
            output = this.activeRecipe.craft(this.getStackInSlot(0), this.getExpansions(), false);
            if (output != null) {
                ItemStack input = this.getStackInSlot(0);
                if (input.stackSize > output.stackSize) {
                    input.stackSize -= output.stackSize;
                } else {
                    this.setInventorySlotContents(0, null);
                }
                this.outputStack(output, this, 9, false);
                for (int i = 1; i < 9; ++i) {
                    if (this.getStackInSlot(i) == null || this.getStackInSlot((int)i).stackSize != 0) continue;
                    this.setInventorySlotContents(i, null);
                }
            }
        }
    }

    private List<ItemStack> getExpansions() {
        ArrayList<ItemStack> expansions = new ArrayList<ItemStack>();
        for (int i = 1; i < 9; ++i) {
            if (this.getStackInSlot(i) == null) continue;
            expansions.add(this.getStackInSlot(i));
        }
        return expansions;
    }

    private void updateRecipeOutput() {
        List<ItemStack> expansions;
        ItemStack oldClientOutput = this.clientOutputInv.getStackInSlot(0);
        this.activeRecipeValid = false;
        this.clientOutputInv.setInventorySlotContents(0, null);
        if (this.activeRecipe != null && (expansions = this.getExpansions()).size() > 0) {
            this.clientOutputInv.setInventorySlotContents(0, this.activeRecipe.craft(this.getStackInSlot(0), expansions, true));
        }
        boolean bl = this.activeRecipeValid = this.clientOutputInv.getStackInSlot(0) != null;
        if (!StackHelper.isEqualItem(this.clientOutputInv.getStackInSlot(0), oldClientOutput)) {
            this.sendNetworkUpdate();
        }
    }

    private void setNewActiveRecipe() {
        ItemStack input = this.getStackInSlot(0);
        if (input != null && this.activeRecipe != null && this.activeRecipe.isValidInput(input) || input == null && this.activeRecipe == null) {
            return;
        }
        this.activeRecipe = null;
        this.activeRecipeValid = false;
        if (input != null && input.getItem() != null) {
            for (IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
                if (!iIntegrationRecipe.isValidInput(input)) continue;
                this.activeRecipe = iIntegrationRecipe;
                break;
            }
        }
        this.sendNetworkUpdate();
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.getStackInSlot(9);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.canStacksMerge(output, existingOutput) && output.stackSize + existingOutput.stackSize <= output.getMaxStackSize();
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeByte((int)((byte)this.getMaxExpansionCount()));
        NetworkUtils.writeStack(buf, this.clientOutputInv.getStackInSlot(0));
    }

    @Override
    public void readData(ByteBuf buf) {
        this.maxExpCountClient = buf.readByte();
        this.clientOutputInv.setInventorySlotContents(0, NetworkUtils.readStack(buf));
    }

    public int getMaxExpansionCount() {
        return this.worldObj.isRemote ? this.maxExpCountClient : (this.activeRecipe != null ? this.activeRecipe.getMaximumExpansionCount(this.getStackInSlot(0)) : 0);
    }

    @Override
    public int getRequiredEnergy() {
        return this.hasWork() ? this.activeRecipe.getEnergyCost() : 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (this.activeRecipe == null) {
            return false;
        }
        if (slot < 9) {
            int expansionCount = this.activeRecipe.getMaximumExpansionCount(this.getStackInSlot(0));
            if (expansionCount > 0 && slot > expansionCount) {
                return false;
            }
            return this.activeRecipe.isValidExpansion(this.getStackInSlot(0), stack);
        }
        return false;
    }

    public int getSizeInventory() {
        return 10;
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.activeRecipeValid;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        if (slot == 0) {
            this.updateRecipe();
        }
        if (slot < 9) {
            this.updateRecipeOutput();
        }
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack result = super.decrStackSize(slot, amount);
        if (slot == 0) {
            this.updateRecipe();
        }
        if (slot < 9) {
            this.updateRecipeOutput();
        }
        return result;
    }

    public void markDirty() {
        super.markDirty();
        this.updateRecipeOutput();
    }

    private void updateRecipe() {
        this.setNewActiveRecipe();
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (slot == 0) {
            return true;
        }
        if (this.activeRecipe == null) {
            return false;
        }
        if (slot < 9) {
            int expansionCount = this.activeRecipe.getMaximumExpansionCount(this.getStackInSlot(0));
            return expansionCount <= 0 || slot <= expansionCount;
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 9;
    }
}

