/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.silicon.TileLaserTableBase;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.item.ItemStack;

public class TileChargingTable
extends TileLaserTableBase
implements IHasWork {
    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.getEnergy() > 0) {
            if (this.getRequiredEnergy() > 0) {
                ItemStack stack = this.getStackInSlot(0);
                IEnergyContainerItem containerItem = (IEnergyContainerItem)stack.getItem();
                this.addEnergy(0 - containerItem.receiveEnergy(stack, this.getEnergy(), false));
                this.setInventorySlotContents(0, stack);
            } else {
                this.subtractEnergy(Math.min(this.getEnergy(), 10));
            }
        }
    }

    @Override
    public int getRequiredEnergy() {
        ItemStack stack = this.getStackInSlot(0);
        if (stack != null && stack.getItem() != null && stack.getItem() instanceof IEnergyContainerItem) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)stack.getItem();
            return containerItem.getMaxEnergyStored(stack) - containerItem.getEnergyStored(stack);
        }
        return 0;
    }

    @Override
    public boolean hasWork() {
        return this.getRequiredEnergy() > 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public int getSizeInventory() {
        return 1;
    }

    public String getInventoryName() {
        return StringUtils.localize("tile.chargingTableBlock.name");
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot == 0 && stack != null && stack.getItem() != null && stack.getItem() instanceof IEnergyContainerItem;
    }
}

