/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.silicon.EntityPackage;
import buildcraft.silicon.render.PackageFontRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemPackage
extends ItemBuildCraft {
    public ItemPackage() {
        this.setMaxStackSize(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
    }

    public static void update(ItemStack stack) {
    }

    public static ItemStack getStack(ItemStack stack, int slot) {
        NBTTagCompound tag = NBTUtils.getItemData(stack);
        if (tag.hasKey("item" + slot)) {
            return ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("item" + slot));
        }
        return null;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isRemote) {
            world.spawnEntityInWorld((Entity)new EntityPackage(world, player, stack.copy()));
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return new PackageFontRenderer(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List strings, boolean adv) {
        NBTTagCompound tag = NBTUtils.getItemData(stack);
        if (!tag.hasNoTags()) {
            strings.add("SPECIAL:0");
            strings.add("SPECIAL:1");
            strings.add("SPECIAL:2");
        }
    }

    public static final class DispenseBehaviour
    extends BehaviorDefaultDispenseItem {
        public ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
            if (stack != null && stack.getItem() instanceof ItemPackage) {
                World world = source.getWorld();
                EnumFacing enumfacing = BlockDispenser.func_149937_b((int)source.getBlockMetadata());
                EntityPackage entityPackage = new EntityPackage(source.getWorld(), source.getX() + (double)enumfacing.getFrontOffsetX(), source.getY() + (double)enumfacing.getFrontOffsetY(), source.getZ() + (double)enumfacing.getFrontOffsetZ(), stack.copy());
                entityPackage.setThrowableHeading(enumfacing.getFrontOffsetX(), (float)enumfacing.getFrontOffsetY() + 0.1f, enumfacing.getFrontOffsetZ(), 1.1f, 6.0f);
                world.spawnEntityInWorld((Entity)entityPackage);
                stack.splitStack(1);
            }
            return stack;
        }
    }
}

