/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.silicon.ItemPackage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityPackage
extends EntityThrowable {
    private ItemStack pkg;

    public EntityPackage(World world) {
        super(world);
        this.pkg = new ItemStack((Item)BuildCraftSilicon.packageItem);
    }

    public EntityPackage(World world, EntityPlayer player, ItemStack stack) {
        super(world, (EntityLivingBase)player);
        this.pkg = stack;
    }

    public EntityPackage(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z);
        this.pkg = stack;
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound subTag = new NBTTagCompound();
        this.pkg.writeToNBT(subTag);
        compound.setTag("stack", (NBTBase)subTag);
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey("stack")) {
            this.pkg = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("stack"));
        }
    }

    protected void onImpact(MovingObjectPosition target) {
        double z;
        double y;
        double x;
        if (target.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            x = target.entityHit.posX;
            y = target.entityHit.posY;
            z = target.entityHit.posZ;
        } else {
            x = target.blockX;
            y = target.blockY;
            z = target.blockZ;
        }
        float hitPoints = 0.0f;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = ItemPackage.getStack(this.pkg, i);
            if (stack == null) continue;
            hitPoints = stack.getItem() instanceof ItemBlock ? (hitPoints += 0.28f) : (hitPoints += 0.14f);
            float var = 0.7f;
            World world = this.worldObj;
            double dx = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            double dy = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            double dz = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            EntityItem entityitem = new EntityItem(world, x + dx, y + dy, z + dz, stack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
        if (target.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            target.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this), hitPoints);
        }
        this.setDead();
    }
}

