/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.render.ICustomHighlight;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileLaser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLaser
extends BlockBuildCraft
implements ICustomHighlight {
    private static final AxisAlignedBB[][] boxes = new AxisAlignedBB[][]{{AxisAlignedBB.getBoundingBox((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.3125, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.3125, (double)0.25, (double)0.3125, (double)0.6875, (double)0.8125, (double)0.6875)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.3125, (double)0.3125, (double)0.1875, (double)0.6875, (double)0.6875, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25), AxisAlignedBB.getBoundingBox((double)0.3125, (double)0.3125, (double)0.25, (double)0.6875, (double)0.6875, (double)0.8125)}, {AxisAlignedBB.getBoundingBox((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.1875, (double)0.3125, (double)0.3125, (double)0.75, (double)0.6875, (double)0.6875)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.3125, (double)0.3125, (double)0.8125, (double)0.6875, (double)0.6875)}};

    public BlockLaser() {
        super(Material.iron);
        this.setHardness(10.0f);
        this.setCreativeTab(BCCreativeTab.get("main"));
    }

    @Override
    public AxisAlignedBB[] getBoxes(World wrd, int x, int y, int z, EntityPlayer player) {
        return boxes[wrd.getBlockMetadata(x, y, z)];
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    public MovingObjectPosition collisionRayTrace(World wrd, int x, int y, int z, Vec3 origin, Vec3 direction) {
        AxisAlignedBB[] aabbs = boxes[wrd.getBlockMetadata(x, y, z)];
        MovingObjectPosition closest = null;
        for (AxisAlignedBB aabb : aabbs) {
            MovingObjectPosition mop = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z).calculateIntercept(origin, direction);
            if (mop == null) continue;
            closest = closest != null && mop.hitVec.distanceTo(origin) < closest.hitVec.distanceTo(origin) ? mop : mop;
        }
        if (closest != null) {
            closest.blockX = x;
            closest.blockY = y;
            closest.blockZ = z;
        }
        return closest;
    }

    public void addCollisionBoxesToList(World wrd, int x, int y, int z, AxisAlignedBB mask, List list, Entity ent) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = boxes[wrd.getBlockMetadata(x, y, z)]) {
            AxisAlignedBB aabbTmp = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z);
            if (!mask.intersectsWith(aabbTmp)) continue;
            list.add(aabbTmp);
        }
    }

    @Override
    public int getRenderType() {
        return SiliconProxy.laserBlockModel;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileLaser();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess access, int x, int y, int z, int side) {
        return this.getIcon(side, access.getBlockMetadata(x, y, z));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int i, int j) {
        if (i == (j ^ 1)) {
            return this.icons[0][0];
        }
        if (i == j) {
            return this.icons[0][1];
        }
        return this.icons[0][2];
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        super.onBlockPlaced(world, x, y, z, side, par6, par7, par8, meta);
        int retMeta = meta;
        if (side <= 6) {
            retMeta = side;
        }
        return retMeta;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

