/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.api.core.BCLog;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class MapChunk {
    private static final int VERSION = 1;
    private int x;
    private int z;
    private byte[] data;

    public MapChunk(int x, int z) {
        this.x = x;
        this.z = z;
        this.data = new byte[256];
    }

    public MapChunk(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getColor(int x, int z) {
        return this.data[(z & 0xF) << 4 | x & 0xF];
    }

    public void update(Chunk chunk) {
        for (int bz = 0; bz < 16; ++bz) {
            for (int bx = 0; bx < 16; ++bx) {
                int y = chunk.getHeightValue(bx, bz);
                int color = MapColor.airColor.colorIndex;
                if (y < 0) {
                    y = 255;
                }
                while (y >= 0) {
                    Block b = chunk.getBlock(bx, y, bz);
                    int n = color = b.getMapColor(0) != null ? b.getMapColor((int)0).colorIndex : MapColor.airColor.colorIndex;
                    if (color != MapColor.airColor.colorIndex) break;
                    --y;
                }
                this.data[bz << 4 | bx] = (byte)color;
            }
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        short version = compound.getShort("version");
        if (version > 1) {
            BCLog.logger.error("Unsupported MapChunk version: " + version);
            return;
        }
        this.x = compound.getInteger("x");
        this.z = compound.getInteger("z");
        this.data = compound.getByteArray("data");
        if (this.data.length != 256) {
            BCLog.logger.error("Invalid MapChunk data length: " + this.data.length);
            this.data = new byte[256];
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.setShort("version", (short)1);
        compound.setInteger("x", this.x);
        compound.setInteger("z", this.z);
        compound.setByteArray("data", this.data);
    }

    public int hashCode() {
        return 31 * this.x + this.z;
    }
}

