/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.robotics.TileRequester;
import buildcraft.robotics.gui.ContainerRequester;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiRequester
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftrobotics:textures/gui/requester_gui.png");
    private TileRequester requester;

    public GuiRequester(IInventory iPlayerInventory, TileRequester iRequester) {
        super(new ContainerRequester(iPlayerInventory, iRequester), iPlayerInventory, TEXTURE);
        this.getContainer().gui = this;
        this.getContainer().getRequestList();
        this.xSize = 196;
        this.ySize = 181;
        this.requester = iRequester;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.slots.add(new RequestSlot(this, x * 5 + y, 9 + 18 * x, 7 + 18 * y));
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(f, x, y);
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void slotClicked(AdvancedSlot slot, int mouseButton) {
        super.slotClicked(slot, mouseButton);
        if (slot instanceof RequestSlot) {
            ((RequestSlot)slot).setItem(this.mc.thePlayer.inventory.getItemStack());
        }
    }

    @Override
    public ContainerRequester getContainer() {
        return (ContainerRequester)super.getContainer();
    }

    private static class RequestSlot
    extends AdvancedSlot {
        private int index;

        public RequestSlot(GuiAdvancedInterface gui, int iIndex, int x, int y) {
            super(gui, x, y);
            this.index = iIndex;
        }

        public void setItem(ItemStack itemStack) {
            TileRequester requester = ((GuiRequester)this.gui).requester;
            requester.setRequest(this.index, itemStack);
            ((GuiRequester)this.gui).getContainer().getRequestList();
        }

        @Override
        public ItemStack getItemStack() {
            ContainerRequester requester = ((GuiRequester)this.gui).getContainer();
            return requester.requests[this.index];
        }
    }
}

