/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.IInjectable;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.filters.ArrayStackOrListFilter;
import buildcraft.robotics.statements.ActionRobotFilter;
import buildcraft.robotics.statements.ActionStationAcceptItems;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotUnload
extends AIRobot {
    private int waitedCycles = 0;

    public AIRobotUnload(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void update() {
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            if (AIRobotUnload.unload(this.robot, this.robot.getDockingStation(), true)) {
                this.waitedCycles = 0;
            } else {
                this.setSuccess(!this.robot.containsItems());
                this.terminate();
            }
        }
    }

    public static boolean unload(EntityRobotBase robot, DockingStation station, boolean doUnload) {
        if (station == null) {
            return false;
        }
        IInjectable output = station.getItemOutput();
        if (output == null) {
            return false;
        }
        ForgeDirection injectSide = station.getItemOutputSide();
        if (!output.canInjectItems(injectSide)) {
            return false;
        }
        for (IInvSlot robotSlot : InventoryIterator.getIterable(robot, ForgeDirection.UNKNOWN)) {
            ItemStack stack;
            int used;
            if (robotSlot.getStackInSlot() == null || !ActionRobotFilter.canInteractWithItem(station, new ArrayStackOrListFilter(robotSlot.getStackInSlot()), ActionStationAcceptItems.class) || (used = output.injectItem(stack = robotSlot.getStackInSlot(), doUnload, injectSide, null)) <= 0) continue;
            if (doUnload) {
                robotSlot.decreaseStackInSlot(used);
            }
            return true;
        }
        if (robot.getHeldItem() != null) {
            if (!ActionRobotFilter.canInteractWithItem(station, new ArrayStackOrListFilter(robot.getHeldItem()), ActionStationAcceptItems.class)) {
                return false;
            }
            ItemStack stack = robot.getHeldItem();
            int used = output.injectItem(stack, doUnload, injectSide, null);
            if (used > 0) {
                if (doUnload) {
                    if (stack.stackSize <= used) {
                        robot.setItemInUse(null);
                    } else {
                        stack.stackSize -= used;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getEnergyCost() {
        return 10;
    }
}

