/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import net.minecraft.entity.Entity;

public class AIRobotShutdown
extends AIRobot {
    private int skip = 0;
    private double motionX;
    private double motionZ;

    public AIRobotShutdown(EntityRobotBase iRobot) {
        super(iRobot);
        this.motionX = this.robot.motionX;
        this.motionZ = this.robot.motionZ;
    }

    @Override
    public void start() {
        this.robot.undock();
        this.robot.motionX = this.motionX;
        this.robot.motionY = -0.075f;
        this.robot.motionZ = this.motionZ;
    }

    private boolean isBlocked(float yOffset) {
        return this.robot.worldObj.getCollidingBoundingBoxes((Entity)this.robot, this.robot.getBoundingBox().addCoord(this.robot.motionX, (double)yOffset, this.robot.motionZ)).size() > 0;
    }

    @Override
    public void update() {
        if (this.skip == 0) {
            if (!this.isBlocked(-0.075f)) {
                this.robot.motionY = -0.075f;
            } else {
                while (this.isBlocked(0.0f)) {
                    this.robot.posY += (double)0.075f;
                }
                this.robot.motionY = 0.0;
                if (this.robot.motionX != 0.0 || this.robot.motionZ != 0.0) {
                    this.robot.motionX = 0.0;
                    this.robot.motionZ = 0.0;
                    this.skip = 0;
                } else {
                    this.skip = 20;
                }
            }
        } else {
            --this.skip;
        }
    }

    @Override
    public int getEnergyCost() {
        return 0;
    }
}

