/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.StackRequest;
import buildcraft.robotics.ai.AIRobotSearchStation;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;

public class AIRobotSearchStackRequest
extends AIRobot {
    public StackRequest request = null;
    public DockingStation station = null;
    private Collection<ItemStack> blackList;
    private IStackFilter filter;

    public AIRobotSearchStackRequest(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchStackRequest(EntityRobotBase iRobot, IStackFilter iFilter, Collection<ItemStack> iBlackList) {
        this(iRobot);
        this.blackList = iBlackList;
        this.filter = iFilter;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchStation(this.robot, new StationProviderFilter(), this.robot.getZoneToWork()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (ai.success()) {
                this.request = this.getOrderFromRequestingStation(((AIRobotSearchStation)ai).targetStation, true);
            }
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.request != null;
    }

    private boolean isBlacklisted(ItemStack stack) {
        for (ItemStack black : this.blackList) {
            if (!StackHelper.isMatchingItem(stack, black)) continue;
            return true;
        }
        return false;
    }

    private StackRequest getOrderFromRequestingStation(DockingStation station, boolean take) {
        for (StackRequest req : this.getAvailableRequests(station)) {
            if (this.isBlacklisted(req.getStack()) || !this.filter.matches(req.getStack())) continue;
            req.setStation(station);
            if (take) {
                if (!this.robot.getRegistry().take(req.getResourceId(this.robot.worldObj), this.robot)) continue;
                return req;
            }
            return req;
        }
        return null;
    }

    private Collection<StackRequest> getAvailableRequests(DockingStation station) {
        ArrayList<StackRequest> result = new ArrayList<StackRequest>();
        IRequestProvider provider = station.getRequestProvider();
        if (provider == null) {
            return result;
        }
        for (int i = 0; i < provider.getRequestsCount(); ++i) {
            if (provider.getRequest(i) == null) continue;
            StackRequest req = new StackRequest(provider, i, provider.getRequest(i));
            req.setStation(station);
            if (this.robot.getRegistry().isTaken(req.getResourceId(this.robot.worldObj))) continue;
            result.add(req);
        }
        return result;
    }

    private class StationProviderFilter
    implements IStationFilter {
        private StationProviderFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            return AIRobotSearchStackRequest.this.getOrderFromRequestingStation(station, false) != null;
        }
    }
}

