/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotSearchBlock;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotSearchAndGotoBlock
extends AIRobot {
    private BlockIndex blockFound = null;
    private IBlockFilter filter = null;
    private boolean random = false;
    private double maxDistanceToEnd;

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot, boolean iRandom, IBlockFilter iPathFound) {
        this(iRobot, iRandom, iPathFound, 0.0);
    }

    public AIRobotSearchAndGotoBlock(EntityRobotBase iRobot, boolean iRandom, IBlockFilter iPathFound, double iMaxDistanceToEnd) {
        this(iRobot);
        this.random = iRandom;
        this.filter = iPathFound;
        this.maxDistanceToEnd = iMaxDistanceToEnd;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchBlock(this.robot, this.random, this.filter, this.maxDistanceToEnd));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchBlock) {
            if (ai.success()) {
                AIRobotSearchBlock searchAI = (AIRobotSearchBlock)ai;
                if (searchAI.takeResource()) {
                    this.blockFound = searchAI.blockFound;
                    this.startDelegateAI(new AIRobotGotoBlock(this.robot, searchAI.path));
                } else {
                    this.terminate();
                }
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (!ai.success()) {
                this.releaseBlockFound();
            }
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.blockFound != null;
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public BlockIndex getBlockFound() {
        return this.blockFound;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.setTag("indexStored", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("indexStored")) {
            this.blockFound = new BlockIndex(nbt.getCompoundTag("indexStored"));
        }
    }
}

