/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;

public abstract class AIRobotGoto
extends AIRobot {
    protected float nextX;
    protected float nextY;
    protected float nextZ;
    protected double dirX;
    protected double dirY;
    protected double dirZ;

    public AIRobotGoto(EntityRobotBase iRobot) {
        super(iRobot);
    }

    protected void setDestination(EntityRobotBase robot, float x, float y, float z) {
        this.nextX = x;
        this.nextY = y;
        this.nextZ = z;
        this.dirX = (double)this.nextX - robot.posX;
        this.dirY = (double)this.nextY - robot.posY;
        this.dirZ = (double)this.nextZ - robot.posZ;
        double magnitude = Math.sqrt(this.dirX * this.dirX + this.dirY * this.dirY + this.dirZ * this.dirZ);
        if (magnitude != 0.0) {
            this.dirX /= magnitude;
            this.dirY /= magnitude;
            this.dirZ /= magnitude;
        } else {
            this.dirX = 0.0;
            this.dirY = 0.0;
            this.dirZ = 0.0;
        }
        robot.motionX = this.dirX / 10.0;
        robot.motionY = this.dirY / 10.0;
        robot.motionZ = this.dirZ / 10.0;
    }

    @Override
    public int getEnergyCost() {
        return 3;
    }
}

