/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileRequester
extends TileBuildCraft
implements IInventory,
IRequestProvider,
ICommandReceiver {
    public static final int NB_ITEMS = 20;
    private SimpleInventory inv = new SimpleInventory(20, "items", 64);
    private SimpleInventory requests = new SimpleInventory(20, "requests", 64);

    public void setRequest(final int index, final ItemStack stack) {
        if (this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setRequest", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeByte(index);
                    NetworkUtils.writeStack(data, stack);
                }
            }));
        } else {
            this.requests.setInventorySlotContents(index, stack);
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "setRequest".equals(command)) {
            this.setRequest(stream.readUnsignedByte(), NetworkUtils.readStack(stream));
        }
    }

    public ItemStack getRequestTemplate(int index) {
        return this.requests.getStackInSlot(index);
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inv.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        return this.inv.decrStackSize(slotId, count);
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        return this.inv.getStackInSlotOnClosing(slotId);
    }

    public void setInventorySlotContents(int slotId, ItemStack itemStack) {
        this.inv.setInventorySlotContents(slotId, itemStack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return this.inv.isUseableByPlayer(entityPlayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        if (this.requests.getStackInSlot(i) == null) {
            return false;
        }
        if (!StackHelper.isMatchingItemOrList(this.requests.getStackInSlot(i), itemStack)) {
            return false;
        }
        return this.inv.isItemValidForSlot(i, itemStack);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.setTag("inv", (NBTBase)invNBT);
        NBTTagCompound reqNBT = new NBTTagCompound();
        this.requests.writeToNBT(reqNBT);
        nbt.setTag("req", (NBTBase)reqNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.inv.readFromNBT(nbt.getCompoundTag("inv"));
        this.requests.readFromNBT(nbt.getCompoundTag("req"));
    }

    public boolean isFulfilled(int i) {
        if (this.requests.getStackInSlot(i) == null) {
            return true;
        }
        if (this.inv.getStackInSlot(i) == null) {
            return false;
        }
        return StackHelper.isMatchingItemOrList(this.requests.getStackInSlot(i), this.inv.getStackInSlot(i)) && this.inv.getStackInSlot((int)i).stackSize >= this.requests.getStackInSlot((int)i).stackSize;
    }

    @Override
    public int getRequestsCount() {
        return 20;
    }

    @Override
    public ItemStack getRequest(int i) {
        if (this.requests.getStackInSlot(i) == null) {
            return null;
        }
        if (this.isFulfilled(i)) {
            return null;
        }
        ItemStack request = this.requests.getStackInSlot(i).copy();
        ItemStack existingStack = this.inv.getStackInSlot(i);
        if (existingStack == null) {
            return request;
        }
        if (!StackHelper.isMatchingItemOrList(request, existingStack)) {
            return null;
        }
        request.stackSize -= existingStack.stackSize;
        if (request.stackSize <= 0) {
            return null;
        }
        return request;
    }

    @Override
    public ItemStack offerItem(int i, ItemStack stack) {
        ItemStack existingStack = this.inv.getStackInSlot(i);
        if (this.requests.getStackInSlot(i) == null) {
            return stack;
        }
        if (existingStack == null) {
            if (!StackHelper.isMatchingItemOrList(stack, this.requests.getStackInSlot(i))) {
                return stack;
            }
            int maxQty = this.requests.getStackInSlot((int)i).stackSize;
            if (stack.stackSize <= maxQty) {
                this.inv.setInventorySlotContents(i, stack);
                return null;
            }
            ItemStack newStack = stack.copy();
            newStack.stackSize = maxQty;
            stack.stackSize -= maxQty;
            this.inv.setInventorySlotContents(i, newStack);
            return stack;
        }
        if (!StackHelper.isMatchingItemOrList(stack, existingStack)) {
            return stack;
        }
        if (StackHelper.isMatchingItemOrList(stack, this.requests.getStackInSlot(i))) {
            int maxQty = this.requests.getStackInSlot((int)i).stackSize;
            if (existingStack.stackSize + stack.stackSize <= maxQty) {
                existingStack.stackSize += stack.stackSize;
                return null;
            }
            stack.stackSize -= maxQty - existingStack.stackSize;
            existingStack.stackSize = maxQty;
            return stack;
        }
        return stack;
    }
}

