/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.events.RobotEvent;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRobotOverlayItem;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemWrench;
import buildcraft.core.LaserData;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.robotics.EntityRobotEnergyParticle;
import buildcraft.robotics.ItemRobot;
import buildcraft.robotics.RobotRegistry;
import buildcraft.robotics.ai.AIRobotMain;
import buildcraft.robotics.ai.AIRobotShutdown;
import buildcraft.robotics.ai.AIRobotSleep;
import buildcraft.robotics.statements.ActionRobotWorkInArea;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EntityRobot
extends EntityRobotBase
implements IEntityAdditionalSpawnData,
IInventory,
IFluidHandler,
ICommandReceiver,
IDebuggable {
    public static final ResourceLocation ROBOT_BASE = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/robot_base.png");
    public static final int MAX_WEARABLES = 8;
    public static final int TRANSFER_INV_SLOTS = 4;
    private static Set<Integer> blacklistedItemsForUpdate = Sets.newHashSet();
    public LaserData laser = new LaserData();
    public DockingStation linkedDockingStation;
    public BlockIndex linkedDockingStationIndex;
    public ForgeDirection linkedDockingStationSide;
    public BlockIndex currentDockingStationIndex;
    public ForgeDirection currentDockingStationSide;
    public boolean isDocked = false;
    public RedstoneBoardRobot board;
    public AIRobotMain mainAI;
    public ItemStack itemInUse;
    public float itemAngle1 = 0.0f;
    public float itemAngle2 = 0.0f;
    public boolean itemActive = false;
    public float itemActiveStage = 0.0f;
    public long lastUpdateTime = 0L;
    private DockingStation currentDockingStation;
    private List<ItemStack> wearables = new ArrayList<ItemStack>();
    private boolean needsUpdate = false;
    private ItemStack[] inv = new ItemStack[4];
    private FluidStack tank;
    private int maxFluid = 4000;
    private ResourceLocation texture;
    private WeakHashMap<Entity, Long> unreachableEntities = new WeakHashMap();
    private NBTTagList stackRequestNBT;
    private RFBattery battery = new RFBattery(100000, 100000, 100);
    private boolean firstUpdateDone = false;
    private boolean isActiveClient = false;
    private long robotId = Long.MAX_VALUE;
    private int energySpendPerCycle = 0;
    private int ticksCharging = 0;
    private float energyFX = 0.0f;
    private int steamDx = 0;
    private int steamDy = -1;
    private int steamDz = 0;

    public EntityRobot(World world, RedstoneBoardRobotNBT boardNBT) {
        this(world);
        this.board = boardNBT.create(this);
        this.dataWatcher.updateObject(16, (Object)this.board.getNBTHandler().getID());
        if (!world.isRemote) {
            this.mainAI = new AIRobotMain(this);
            this.mainAI.start();
        }
    }

    public EntityRobot(World world) {
        super(world);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.ignoreFrustumCheck = true;
        this.laser.isVisible = false;
        this.entityCollisionReduction = 1.0f;
        this.width = 0.25f;
        this.height = 0.25f;
    }

    protected void entityInit() {
        super.entityInit();
        this.setNullBoundingBox();
        this.preventEntitySpawning = false;
        this.noClip = true;
        this.isImmuneToFire = true;
        this.func_110163_bv();
        this.dataWatcher.addObject(12, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(13, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(14, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(15, (Object)0);
        this.dataWatcher.addObject(16, (Object)"");
        this.dataWatcher.addObject(17, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(18, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(19, (Object)0);
        this.dataWatcher.addObject(20, (Object)0);
        this.dataWatcher.addObject(21, (Object)0);
    }

    protected void updateDataClient() {
        this.laser.tail.x = this.dataWatcher.getWatchableObjectFloat(12);
        this.laser.tail.y = this.dataWatcher.getWatchableObjectFloat(13);
        this.laser.tail.z = this.dataWatcher.getWatchableObjectFloat(14);
        this.laser.isVisible = this.dataWatcher.getWatchableObjectByte(15) == 1;
        RedstoneBoardNBT<?> boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(this.dataWatcher.getWatchableObjectString(16));
        if (boardNBT != null) {
            this.texture = ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        this.itemAngle1 = this.dataWatcher.getWatchableObjectFloat(17);
        this.itemAngle2 = this.dataWatcher.getWatchableObjectFloat(18);
        this.energySpendPerCycle = this.dataWatcher.getWatchableObjectInt(19);
        this.isActiveClient = this.dataWatcher.getWatchableObjectByte(20) == 1;
        this.battery.setEnergy(this.dataWatcher.getWatchableObjectInt(21));
    }

    protected void updateDataServer() {
        this.dataWatcher.updateObject(12, (Object)Float.valueOf((float)this.laser.tail.x));
        this.dataWatcher.updateObject(13, (Object)Float.valueOf((float)this.laser.tail.y));
        this.dataWatcher.updateObject(14, (Object)Float.valueOf((float)this.laser.tail.z));
        this.dataWatcher.updateObject(15, (Object)((byte)(this.laser.isVisible ? 1 : 0)));
        this.dataWatcher.updateObject(17, (Object)Float.valueOf(this.itemAngle1));
        this.dataWatcher.updateObject(18, (Object)Float.valueOf(this.itemAngle2));
    }

    public boolean isActive() {
        if (this.worldObj.isRemote) {
            return this.isActiveClient;
        }
        return this.mainAI.getActiveAI() instanceof AIRobotSleep || this.mainAI.getActiveAI() instanceof AIRobotShutdown;
    }

    protected void init() {
        if (this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "requestInitialization", null));
        }
    }

    public void setLaserDestination(float x, float y, float z) {
        if ((double)x != this.laser.tail.x || (double)y != this.laser.tail.y || (double)z != this.laser.tail.z) {
            this.laser.tail.x = x;
            this.laser.tail.y = y;
            this.laser.tail.z = z;
            this.needsUpdate = true;
        }
    }

    public void showLaser() {
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
            this.needsUpdate = true;
        }
    }

    public void hideLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            this.needsUpdate = true;
        }
    }

    protected void firstUpdate() {
        if (this.stackRequestNBT != null) {
            // empty if block
        }
        if (!this.worldObj.isRemote) {
            this.getRegistry().registerRobot(this);
        }
    }

    public String getCommandSenderName() {
        return StatCollector.translateToLocal((String)"item.robot.name");
    }

    public void onEntityUpdate() {
        this.worldObj.theProfiler.startSection("bcEntityRobot");
        if (!this.firstUpdateDone) {
            this.firstUpdate();
            this.firstUpdateDone = true;
        }
        if (this.ticksCharging > 0) {
            --this.ticksCharging;
        }
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(20, (Object)((byte)(this.isActive() && this.ticksCharging == 0 ? 1 : 0)));
            this.dataWatcher.updateObject(21, (Object)this.getEnergy());
            if (this.needsUpdate) {
                this.updateDataServer();
                this.needsUpdate = false;
            }
        }
        if (this.worldObj.isRemote) {
            this.updateDataClient();
            this.updateRotationYaw(60.0f);
            this.updateEnergyFX();
        }
        if (this.currentDockingStation != null) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.posX = (float)this.currentDockingStation.x() + 0.5f + (float)this.currentDockingStation.side().offsetX * 0.5f;
            this.posY = (float)this.currentDockingStation.y() + 0.5f + (float)this.currentDockingStation.side().offsetY * 0.5f;
            this.posZ = (float)this.currentDockingStation.z() + 0.5f + (float)this.currentDockingStation.side().offsetZ * 0.5f;
        }
        if (!this.worldObj.isRemote) {
            if (this.linkedDockingStation == null) {
                if (this.linkedDockingStationIndex != null) {
                    this.linkedDockingStation = this.getRegistry().getStation(this.linkedDockingStationIndex.x, this.linkedDockingStationIndex.y, this.linkedDockingStationIndex.z, this.linkedDockingStationSide);
                }
                if (this.linkedDockingStation == null) {
                    this.shutdown("no docking station");
                } else if (this.linkedDockingStation.robotTaking() != this) {
                    if (this.linkedDockingStation.robotIdTaking() == this.robotId) {
                        BCLog.logger.warn("A robot entity was not properly unloaded");
                        this.linkedDockingStation.invalidateRobotTakingEntity();
                    }
                    if (this.linkedDockingStation.robotTaking() != this) {
                        this.shutdown("wrong docking station");
                    }
                }
            }
            if (this.currentDockingStationIndex != null && this.currentDockingStation == null) {
                this.currentDockingStation = this.getRegistry().getStation(this.currentDockingStationIndex.x, this.currentDockingStationIndex.y, this.currentDockingStationIndex.z, this.currentDockingStationSide);
            }
            if (this.posY < -128.0) {
                this.isDead = true;
                BCLog.logger.info("Destroying robot " + this.toString() + " - Fallen into Void");
                this.getRegistry().killRobot(this);
            }
            if (this.linkedDockingStation == null || this.linkedDockingStation.isInitialized()) {
                this.worldObj.theProfiler.startSection("bcRobotAI");
                this.mainAI.cycle();
                this.worldObj.theProfiler.endSection();
                if (this.energySpendPerCycle != this.mainAI.getActiveAI().getEnergyCost()) {
                    this.energySpendPerCycle = this.mainAI.getActiveAI().getEnergyCost();
                    this.dataWatcher.updateObject(19, (Object)this.energySpendPerCycle);
                }
            }
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.updateItem(this.inv[i], i, false);
        }
        this.updateItem(this.itemInUse, 0, true);
        super.onEntityUpdate();
        this.worldObj.theProfiler.endSection();
    }

    protected void updateEntityActionState() {
    }

    public boolean handleWaterMovement() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEnergyFX() {
        this.energyFX += (float)this.energySpendPerCycle;
        if (this.energyFX >= (float)(100 << 2 * Minecraft.getMinecraft().gameSettings.particleSetting)) {
            this.energyFX = 0.0f;
            this.spawnEnergyFX();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEnergyFX() {
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityRobotEnergyParticle(this.worldObj, this.posX + (double)this.steamDx * 0.25, this.posY + (double)this.steamDy * 0.25, this.posZ + (double)this.steamDz * 0.25, (double)this.steamDx * 0.05, (double)this.steamDy * 0.05, (double)this.steamDz * 0.05, (float)this.energySpendPerCycle * 0.075f < 1.0f ? 1.0f : (float)this.energySpendPerCycle * 0.075f));
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)(this.posX - 0.25), (double)(this.posY - 0.25), (double)(this.posZ - 0.25), (double)(this.posX + 0.25), (double)(this.posY + 0.25), (double)(this.posZ + 0.25));
    }

    public void setNullBoundingBox() {
        this.width = 0.0f;
        this.height = 0.0f;
        this.boundingBox.minX = this.posX;
        this.boundingBox.minY = this.posY;
        this.boundingBox.minZ = this.posZ;
        this.boundingBox.maxX = this.posX;
        this.boundingBox.maxY = this.posY;
        this.boundingBox.maxZ = this.posZ;
    }

    private void shutdown(String reason) {
        if (!(this.mainAI.getDelegateAI() instanceof AIRobotShutdown)) {
            BCLog.logger.info("Shutting down robot " + this.toString() + " - " + reason);
            this.mainAI.startDelegateAI(new AIRobotShutdown(this));
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.wearables.size());
        for (ItemStack s : this.wearables) {
            NetworkUtils.writeStack(data, s);
        }
    }

    public void readSpawnData(ByteBuf data) {
        for (int amount = data.readUnsignedByte(); amount > 0; --amount) {
            this.wearables.add(NetworkUtils.readStack(data));
        }
        this.init();
    }

    public ItemStack getHeldItem() {
        return this.itemInUse;
    }

    public void setCurrentItemOrArmor(int i, ItemStack itemstack) {
    }

    public ItemStack[] getLastActiveItems() {
        return new ItemStack[0];
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public void moveEntityWithHeading(float par1, float par2) {
        this.setPosition(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
    }

    public boolean isOnLadder() {
        return false;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        if (this.linkedDockingStationIndex != null) {
            NBTTagCompound linkedStationNBT = new NBTTagCompound();
            NBTTagCompound linkedStationIndexNBT = new NBTTagCompound();
            this.linkedDockingStationIndex.writeTo(linkedStationIndexNBT);
            linkedStationNBT.setTag("index", (NBTBase)linkedStationIndexNBT);
            linkedStationNBT.setByte("side", (byte)this.linkedDockingStationSide.ordinal());
            nbt.setTag("linkedStation", (NBTBase)linkedStationNBT);
        }
        if (this.currentDockingStationIndex != null) {
            NBTTagCompound currentStationNBT = new NBTTagCompound();
            NBTTagCompound currentStationIndexNBT = new NBTTagCompound();
            this.currentDockingStationIndex.writeTo(currentStationIndexNBT);
            currentStationNBT.setTag("index", (NBTBase)currentStationIndexNBT);
            currentStationNBT.setByte("side", (byte)this.currentDockingStationSide.ordinal());
            nbt.setTag("currentStation", (NBTBase)currentStationNBT);
        }
        NBTTagCompound nbtLaser = new NBTTagCompound();
        this.laser.writeToNBT(nbtLaser);
        nbt.setTag("laser", (NBTBase)nbtLaser);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        nbt.setTag("battery", (NBTBase)batteryNBT);
        if (this.itemInUse != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.itemInUse.writeToNBT(itemNBT);
            nbt.setTag("itemInUse", (NBTBase)itemNBT);
            nbt.setBoolean("itemActive", this.itemActive);
        }
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (this.inv[i] == null) continue;
            nbt.setTag("inv[" + i + "]", (NBTBase)this.inv[i].writeToNBT(stackNbt));
        }
        if (this.wearables.size() > 0) {
            NBTTagList wearableList = new NBTTagList();
            for (ItemStack wearable : this.wearables) {
                NBTTagCompound item = new NBTTagCompound();
                wearable.writeToNBT(item);
                wearableList.appendTag((NBTBase)item);
            }
            nbt.setTag("wearables", (NBTBase)wearableList);
        }
        NBTTagCompound ai = new NBTTagCompound();
        this.mainAI.writeToNBT(ai);
        nbt.setTag("mainAI", (NBTBase)ai);
        if (this.mainAI.getDelegateAI() != this.board) {
            NBTTagCompound boardNBT = new NBTTagCompound();
            this.board.writeToNBT(boardNBT);
            nbt.setTag("board", (NBTBase)boardNBT);
        }
        nbt.setLong("robotId", this.robotId);
        if (this.tank != null) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            this.tank.writeToNBT(tankNBT);
            nbt.setTag("tank", (NBTBase)tankNBT);
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        if (nbt.hasKey("linkedStation")) {
            NBTTagCompound linkedStationNBT = nbt.getCompoundTag("linkedStation");
            this.linkedDockingStationIndex = new BlockIndex(linkedStationNBT.getCompoundTag("index"));
            this.linkedDockingStationSide = ForgeDirection.values()[linkedStationNBT.getByte("side")];
        }
        if (nbt.hasKey("currentStation")) {
            NBTTagCompound currentStationNBT = nbt.getCompoundTag("currentStation");
            this.currentDockingStationIndex = new BlockIndex(currentStationNBT.getCompoundTag("index"));
            this.currentDockingStationSide = ForgeDirection.values()[currentStationNBT.getByte("side")];
        }
        this.laser.readFromNBT(nbt.getCompoundTag("laser"));
        this.battery.readFromNBT(nbt.getCompoundTag("battery"));
        this.wearables.clear();
        if (nbt.hasKey("wearables")) {
            NBTTagList list = nbt.getTagList("wearables", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)list.getCompoundTagAt(i));
                if (stack == null) continue;
                this.wearables.add(stack);
            }
        }
        if (nbt.hasKey("itemInUse")) {
            this.itemInUse = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("itemInUse"));
            this.itemActive = nbt.getBoolean("itemActive");
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("inv[" + i + "]"));
        }
        NBTTagCompound ai = nbt.getCompoundTag("mainAI");
        this.mainAI = (AIRobotMain)AIRobot.loadAI(ai, this);
        this.board = nbt.hasKey("board") ? (RedstoneBoardRobot)AIRobot.loadAI(nbt.getCompoundTag("board"), this) : (RedstoneBoardRobot)this.mainAI.getDelegateAI();
        if (this.board == null) {
            this.board = RedstoneBoardRegistry.instance.getEmptyRobotBoard().create(this);
        }
        this.dataWatcher.updateObject(16, (Object)this.board.getNBTHandler().getID());
        this.stackRequestNBT = nbt.getTagList("stackRequests", 10);
        if (nbt.hasKey("robotId")) {
            this.robotId = nbt.getLong("robotId");
        }
        this.tank = nbt.hasKey("tank") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.getCompoundTag("tank")) : null;
        this.func_110163_bv();
    }

    @Override
    public void dock(DockingStation station) {
        this.currentDockingStation = station;
        this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
        this.currentDockingStationIndex = this.currentDockingStation.index();
        this.currentDockingStationSide = this.currentDockingStation.side();
    }

    @Override
    public void undock() {
        if (this.currentDockingStation != null) {
            this.currentDockingStation.release(this);
            this.currentDockingStation = null;
            this.setSteamDirection(0, -1, 0);
            this.currentDockingStationIndex = null;
            this.currentDockingStationSide = null;
        }
    }

    @Override
    public DockingStation getDockingStation() {
        return this.currentDockingStation;
    }

    @Override
    public void setMainStation(DockingStation station) {
        if (this.linkedDockingStation != null && this.linkedDockingStation != station) {
            this.linkedDockingStation.unsafeRelease(this);
        }
        this.linkedDockingStation = station;
        if (station != null) {
            this.linkedDockingStationIndex = this.linkedDockingStation.index();
            this.linkedDockingStationSide = this.linkedDockingStation.side();
        } else {
            this.linkedDockingStationIndex = null;
            this.linkedDockingStationSide = ForgeDirection.UNKNOWN;
        }
    }

    public ItemStack getEquipmentInSlot(int var1) {
        return null;
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int var1) {
        return this.inv[var1];
    }

    public ItemStack decrStackSize(int var1, int var2) {
        ItemStack result = this.inv[var1].splitStack(var2);
        if (this.inv[var1].stackSize == 0) {
            this.inv[var1] = null;
        }
        this.updateClientSlot(var1);
        return result;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        ItemStack stack = this.inv[var1];
        this.inv[var1] = null;
        return stack;
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.inv[var1] = var2;
        this.updateClientSlot(var1);
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public void updateClientSlot(final int slot) {
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "clientSetInventory", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeShort(slot);
                NetworkUtils.writeStack(data, EntityRobot.this.inv[slot]);
            }
        }), (Entity)this);
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return this.inv[var1] == null || this.inv[var1].isItemEqual(var2) && this.inv[var1].isStackable() && this.inv[var1].stackSize + var2.stackSize <= this.inv[var1].getItem().getItemStackLimit(this.inv[var1]);
    }

    @Override
    public boolean isMoving() {
        return this.motionX != 0.0 || this.motionY != 0.0 || this.motionZ != 0.0;
    }

    @Override
    public void setItemInUse(ItemStack stack) {
        this.itemInUse = stack;
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "clientSetItemInUse", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeStack(data, EntityRobot.this.itemInUse);
            }
        }), (Entity)this);
    }

    private void setSteamDirection(final int x, final int y, final int z) {
        if (!this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "setSteamDirection", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeInt(x);
                    data.writeShort(y);
                    data.writeInt(z);
                }
            }), (Entity)this);
        } else {
            Vec3 v = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            v = v.normalize();
            this.steamDx = (int)v.xCoord;
            this.steamDy = (int)v.yCoord;
            this.steamDz = (int)v.zCoord;
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("clientSetItemInUse".equals(command)) {
                this.itemInUse = NetworkUtils.readStack(stream);
            } else if ("clientSetInventory".equals(command)) {
                int slot = stream.readUnsignedShort();
                this.inv[slot] = NetworkUtils.readStack(stream);
            } else if ("initialize".equals(command)) {
                this.itemInUse = NetworkUtils.readStack(stream);
                this.itemActive = stream.readBoolean();
            } else if ("setItemActive".equals(command)) {
                this.itemActive = stream.readBoolean();
                this.itemActiveStage = 0.0f;
                this.lastUpdateTime = new Date().getTime();
                if (!this.itemActive) {
                    this.setSteamDirection(0, -1, 0);
                }
            } else if ("setSteamDirection".equals(command)) {
                this.setSteamDirection(stream.readInt(), stream.readShort(), stream.readInt());
            } else if ("syncWearables".equals(command)) {
                this.wearables.clear();
                for (int amount = stream.readUnsignedByte(); amount > 0; --amount) {
                    this.wearables.add(NetworkUtils.readStack(stream));
                }
            }
        } else if (side.isServer()) {
            EntityPlayer p = (EntityPlayer)sender;
            if ("requestInitialization".equals(command)) {
                BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "initialize", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeStack(data, EntityRobot.this.itemInUse);
                        data.writeBoolean(EntityRobot.this.itemActive);
                    }
                }));
                int i = 0;
                while (i < this.inv.length) {
                    final int j = i++;
                    BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "clientSetInventory", new CommandWriter(){

                        @Override
                        public void write(ByteBuf data) {
                            data.writeShort(j);
                            NetworkUtils.writeStack(data, EntityRobot.this.inv[j]);
                        }
                    }));
                }
                if (this.currentDockingStation != null) {
                    this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
                } else {
                    this.setSteamDirection(0, -1, 0);
                }
            }
        }
    }

    public void setHealth(float par1) {
    }

    public boolean attackEntityFrom(DamageSource source, float f) {
        Entity src = source.getSourceOfDamage();
        if (src != null && !(src instanceof EntityFallingBlock) && !(src instanceof IMob) && this.currentDockingStation == null) {
            if (ForgeHooks.onLivingAttack((EntityLivingBase)this, (DamageSource)source, (float)f)) {
                return false;
            }
            if (!this.worldObj.isRemote) {
                this.maxHurtTime = 10;
                this.hurtTime = 10;
                int mul = 2600;
                for (ItemStack s : this.wearables) {
                    if (s.getItem() instanceof ItemArmor) {
                        mul = mul * 2 / (2 + ((ItemArmor)s.getItem()).damageReduceAmount);
                        continue;
                    }
                    mul = (int)((double)mul * 0.7);
                }
                int energy = Math.round(f * (float)mul);
                if (this.battery.getEnergyStored() - energy > 0) {
                    this.battery.setEnergy(this.battery.getEnergyStored() - energy);
                    return true;
                }
                this.onRobotHit(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getAimYaw() {
        return this.itemAngle1;
    }

    @Override
    public float getAimPitch() {
        return this.itemAngle2;
    }

    @Override
    public void aimItemAt(float yaw, float pitch) {
        this.itemAngle1 = yaw;
        this.itemAngle2 = pitch;
        this.updateDataServer();
    }

    @Override
    public void aimItemAt(int x, int y, int z) {
        int deltaX = x - (int)Math.floor(this.posX);
        int deltaY = y - (int)Math.floor(this.posY);
        int deltaZ = z - (int)Math.floor(this.posZ);
        if (deltaX != 0 || deltaZ != 0) {
            this.itemAngle1 = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) + 180.0f;
        }
        double d3 = MathHelper.sqrt_double((double)(deltaX * deltaX + deltaZ * deltaZ));
        this.itemAngle2 = (float)(-(Math.atan2(deltaY, d3) * 180.0 / Math.PI));
        this.setSteamDirection(deltaX, deltaY, deltaZ);
        this.updateDataServer();
    }

    private void updateRotationYaw(float maxStep) {
        float step = MathHelper.wrapAngleTo180_float((float)(this.itemAngle1 - this.rotationYaw));
        if (step > maxStep) {
            step = maxStep;
        }
        if (step < -maxStep) {
            step = -maxStep;
        }
        this.rotationYaw += step;
    }

    protected float func_110146_f(float targetYaw, float dist) {
        if (this.worldObj.isRemote) {
            float f2 = MathHelper.wrapAngleTo180_float((float)(this.rotationYaw - this.renderYawOffset));
            this.renderYawOffset += f2 * 0.5f;
            float f3 = MathHelper.wrapAngleTo180_float((float)(this.rotationYaw - this.renderYawOffset));
            boolean flag = f3 < -90.0f || f3 >= 90.0f;
            this.renderYawOffset = this.rotationYaw - f3;
            if (f3 * f3 > 2500.0f) {
                this.renderYawOffset += f3 * 0.2f;
            }
            float newDist = dist;
            if (flag) {
                newDist *= -1.0f;
            }
            return newDist;
        }
        return 0.0f;
    }

    @Override
    public void setItemActive(final boolean isActive) {
        if (isActive != this.itemActive) {
            this.itemActive = isActive;
            BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "setItemActive", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeBoolean(isActive);
                }
            }), (Entity)this);
        }
    }

    @Override
    public RedstoneBoardRobot getBoard() {
        return this.board;
    }

    @Override
    public DockingStation getLinkedStation() {
        return this.linkedDockingStation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double par1) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.battery.getEnergyStored();
    }

    @Override
    public RFBattery getBattery() {
        return this.battery;
    }

    protected boolean canDespawn() {
        return false;
    }

    public AIRobot getOverridingAI() {
        return this.mainAI.getOverridingAI();
    }

    public void overrideAI(AIRobot ai) {
        this.mainAI.setOverridingAI(ai);
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.worldObj, (int)this.posX, (int)this.posY, (int)this.posZ).get(), par1Entity))) {
            return;
        }
        if (par1Entity.canAttackWithItem() && !par1Entity.hitByEntity((Entity)this)) {
            Multimap attributes = this.itemInUse != null ? this.itemInUse.getAttributeModifiers() : null;
            float attackDamage = 2.0f;
            int knockback = 0;
            if (attributes != null) {
                for (AttributeModifier modifier : attributes.get((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName())) {
                    switch (modifier.getOperation()) {
                        case 0: {
                            attackDamage = (float)((double)attackDamage + modifier.getAmount());
                            break;
                        }
                        case 1: {
                            attackDamage = (float)((double)attackDamage * modifier.getAmount());
                            break;
                        }
                        case 2: {
                            attackDamage = (float)((double)attackDamage * (1.0 + modifier.getAmount()));
                        }
                    }
                }
            }
            if (par1Entity instanceof EntityLivingBase) {
                attackDamage += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
                knockback += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (attackDamage > 0.0f) {
                int fireAspect = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this);
                if (par1Entity instanceof EntityLivingBase && fireAspect > 0 && !par1Entity.isBurning()) {
                    par1Entity.setFire(fireAspect * 4);
                }
                if (par1Entity.attackEntityFrom((DamageSource)new EntityDamageSource("robot", (Entity)this), attackDamage)) {
                    this.setLastAttacker(par1Entity);
                    if (knockback > 0) {
                        par1Entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                        this.motionX *= 0.6;
                        this.motionZ *= 0.6;
                        this.setSprinting(false);
                    }
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)par1Entity);
                    ItemStack itemstack = this.itemInUse;
                    if (itemstack != null && par1Entity instanceof EntityLivingBase) {
                        itemstack.getItem().hitEntity(itemstack, (EntityLivingBase)par1Entity, (EntityLivingBase)this);
                    }
                    if (this.itemInUse.stackSize == 0) {
                        this.setItemInUse(null);
                    }
                }
            }
        }
    }

    @Override
    public IZone getZoneToWork() {
        return this.getZone(ActionRobotWorkInArea.AreaType.WORK);
    }

    @Override
    public IZone getZoneToLoadUnload() {
        IZone zone = this.getZone(ActionRobotWorkInArea.AreaType.LOAD_UNLOAD);
        if (zone == null) {
            zone = this.getZoneToWork();
        }
        return zone;
    }

    private IZone getZone(ActionRobotWorkInArea.AreaType areaType) {
        if (this.linkedDockingStation != null) {
            for (StatementSlot s : this.linkedDockingStation.getActiveActions()) {
                IZone zone;
                if (!(s.statement instanceof ActionRobotWorkInArea) || ((ActionRobotWorkInArea)s.statement).getAreaType() != areaType || (zone = ActionRobotWorkInArea.getArea(s)) == null) continue;
                return zone;
            }
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFreeSlot() {
        for (ItemStack element : this.inv) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unreachableEntityDetected(Entity entity) {
        this.unreachableEntities.put(entity, this.worldObj.getTotalWorldTime() + 1200L);
    }

    @Override
    public boolean isKnownUnreachable(Entity entity) {
        if (this.unreachableEntities.containsKey(entity)) {
            if (this.unreachableEntities.get(entity) >= this.worldObj.getTotalWorldTime()) {
                return true;
            }
            this.unreachableEntities.remove(entity);
            return false;
        }
        return false;
    }

    protected void onRobotHit(boolean attacked) {
        if (!this.worldObj.isRemote) {
            if (attacked) {
                this.convertToItems();
            } else if (this.wearables.size() > 0) {
                this.entityDropItem(this.wearables.remove(this.wearables.size() - 1), 0.0f);
                this.syncWearablesToClient();
            } else if (this.itemInUse != null) {
                this.entityDropItem(this.itemInUse, 0.0f);
                this.itemInUse = null;
            } else {
                this.convertToItems();
            }
        }
    }

    protected boolean interact(EntityPlayer player) {
        ItemStack stack = player.getCurrentEquippedItem();
        if (stack == null || stack.getItem() == null) {
            return false;
        }
        RobotEvent.Interact robotInteractEvent = new RobotEvent.Interact(this, player, stack);
        MinecraftForge.EVENT_BUS.post((Event)robotInteractEvent);
        if (robotInteractEvent.isCanceled()) {
            return false;
        }
        if (player.isSneaking() && stack.getItem() == BuildCraftCore.wrenchItem) {
            RobotEvent.Dismantle robotDismantleEvent = new RobotEvent.Dismantle(this, player);
            MinecraftForge.EVENT_BUS.post((Event)robotDismantleEvent);
            if (robotDismantleEvent.isCanceled()) {
                return false;
            }
            this.onRobotHit(false);
            if (this.worldObj.isRemote) {
                ((ItemWrench)stack.getItem()).wrenchUsed(player, 0, 0, 0);
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.getItem().isValidArmor(stack, 0, (Entity)this)) {
            if (!this.worldObj.isRemote) {
                this.wearables.add(stack.splitStack(1));
                this.syncWearablesToClient();
            } else {
                player.swingItem();
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.getItem() instanceof IRobotOverlayItem && ((IRobotOverlayItem)stack.getItem()).isValidRobotOverlay(stack)) {
            if (!this.worldObj.isRemote) {
                this.wearables.add(stack.splitStack(1));
                this.syncWearablesToClient();
            } else {
                player.swingItem();
            }
            return true;
        }
        if (this.wearables.size() < 8 && stack.getItem() instanceof ItemSkull) {
            if (!this.worldObj.isRemote) {
                ItemStack skullStack = stack.splitStack(1);
                this.initSkullItem(skullStack);
                this.wearables.add(skullStack);
                this.syncWearablesToClient();
            } else {
                player.swingItem();
            }
            return true;
        }
        return super.interact(player);
    }

    private void initSkullItem(ItemStack skullStack) {
        if (skullStack.hasTagCompound()) {
            Property property;
            NBTTagCompound nbttagcompound = skullStack.getTagCompound();
            GameProfile gameProfile = null;
            if (nbttagcompound.hasKey("SkullOwner", 10)) {
                gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.getCompoundTag("SkullOwner"));
            } else if (nbttagcompound.hasKey("SkullOwner", 8) && !StringUtils.isNullOrEmpty((String)nbttagcompound.getString("SkullOwner"))) {
                gameProfile = new GameProfile(null, nbttagcompound.getString("SkullOwner"));
            }
            if (!(gameProfile == null || StringUtils.isNullOrEmpty((String)gameProfile.getName()) || gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures") || (gameProfile = MinecraftServer.getServer().func_152358_ax().func_152655_a(gameProfile.getName())) == null || (property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null)) != null)) {
                gameProfile = MinecraftServer.getServer().func_147130_as().fillProfileProperties(gameProfile, true);
            }
            if (gameProfile != null && gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures")) {
                NBTTagCompound profileNBT = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)profileNBT, (GameProfile)gameProfile);
                nbttagcompound.setTag("SkullOwner", (NBTBase)profileNBT);
            } else {
                nbttagcompound.removeTag("SkullOwner");
            }
        }
    }

    private void syncWearablesToClient() {
        BuildCraftCore.instance.sendToEntity(new PacketCommand(this, "syncWearables", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeByte(EntityRobot.this.wearables.size());
                for (ItemStack s : EntityRobot.this.wearables) {
                    NetworkUtils.writeStack(data, s);
                }
            }
        }), (Entity)this);
    }

    private List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemRobot.createRobotStack(this.board.getNBTHandler(), this.battery.getEnergyStored()));
        if (this.itemInUse != null) {
            drops.add(this.itemInUse);
        }
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            drops.add(element);
        }
        drops.addAll(this.wearables);
        return drops;
    }

    private void convertToItems() {
        if (!this.worldObj.isRemote && !this.isDead) {
            if (this.mainAI != null) {
                this.mainAI.abort();
            }
            List<ItemStack> drops = this.getDrops();
            for (ItemStack stack : drops) {
                this.entityDropItem(stack, 0.0f);
            }
            this.isDead = true;
        }
        this.getRegistry().killRobot(this);
    }

    public void setDead() {
        if (this.worldObj.isRemote) {
            super.setDead();
        }
    }

    @Override
    public void onChunkUnload() {
        this.getRegistry().unloadRobot(this);
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    public void applyEntityCollision(Entity par1Entity) {
    }

    public void setUniqueRobotId(long iRobotId) {
        this.robotId = iRobotId;
    }

    @Override
    public long getRobotId() {
        return this.robotId;
    }

    @Override
    public RobotRegistry getRegistry() {
        return (RobotRegistry)RobotManager.registryProvider.getRegistry(this.worldObj);
    }

    @Override
    public void releaseResources() {
        this.getRegistry().releaseResources(this);
    }

    @Override
    public ItemStack receiveItem(TileEntity tile, ItemStack stack) {
        if (this.currentDockingStation != null && this.currentDockingStation.index().nextTo(new BlockIndex(tile)) && this.mainAI != null) {
            return this.mainAI.getActiveAI().receiveItem(stack);
        }
        return stack;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result;
        if (this.tank != null && !this.tank.isFluidEqual(resource)) {
            return 0;
        }
        if (this.tank == null) {
            this.tank = new FluidStack(resource.getFluid(), 0);
        }
        if (this.tank.amount + resource.amount <= this.maxFluid) {
            result = resource.amount;
            if (doFill) {
                this.tank.amount += resource.amount;
            }
        } else {
            result = this.maxFluid - this.tank.amount;
            if (doFill) {
                this.tank.amount = this.maxFluid;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank != null && this.tank.isFluidEqual(resource)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result;
        if (this.tank == null) {
            result = null;
        } else if (this.tank.amount <= maxDrain) {
            result = this.tank.copy();
            if (doDrain) {
                this.tank = null;
            }
        } else {
            result = this.tank.copy();
            result.amount = maxDrain;
            if (doDrain) {
                this.tank.amount -= maxDrain;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank == null || this.tank.amount == 0 || this.tank.amount < this.maxFluid && this.tank.getFluid().getID() == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank != null && this.tank.amount != 0 && this.tank.getFluid().getID() == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.tank, this.maxFluid)};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIcon(ItemStack stack, int renderPass) {
        IIcon iicon = super.getItemIcon(stack, renderPass);
        if (iicon == null) {
            iicon = stack.getItem().getIcon(stack, renderPass, null, this.itemInUse, 0);
        }
        return iicon;
    }

    @Override
    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        info.add("Robot " + this.board.getNBTHandler().getID() + " (" + this.getBattery().getEnergyStored() + "/" + this.getBattery().getMaxEnergyStored() + " RF)");
        info.add(String.format("Position: %.2f, %.2f, %.2f", this.posX, this.posY, this.posZ));
        info.add("AI tree:");
        for (AIRobot aiRobot = this.mainAI; aiRobot != null; aiRobot = aiRobot.getDelegateAI()) {
            info.add("- " + RobotManager.getAIRobotName(aiRobot.getClass()) + " (" + ((AIRobot)aiRobot).getEnergyCost() + " RF/t)");
            if (!(aiRobot instanceof IDebuggable)) continue;
            ((IDebuggable)((Object)aiRobot)).getDebugInfo(info, side, debugger, player);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = this.getBattery().receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived > 5 && this.ticksCharging <= 25) {
            this.ticksCharging += 5;
        }
        return energyReceived;
    }

    public List<ItemStack> getWearables() {
        return this.wearables;
    }

    private void updateItem(ItemStack stack, int i, boolean held) {
        int id;
        if (stack != null && stack.getItem() != null && !blacklistedItemsForUpdate.contains(id = Item.getIdFromItem((Item)stack.getItem()))) {
            try {
                stack.getItem().onUpdate(stack, this.worldObj, (Entity)this, i, held);
            }
            catch (Exception e) {
                e.printStackTrace();
                blacklistedItemsForUpdate.add(id);
            }
        }
    }
}

