/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.EnumColor;
import buildcraft.api.gates.IGate;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.inventory.InventoryWrapper;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsWood;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class DockingStationPipe
extends DockingStation
implements IRequestProvider {
    private IInjectable injectablePipe = new IInjectable(){

        @Override
        public boolean canInjectItems(ForgeDirection from) {
            return true;
        }

        @Override
        public int injectItem(ItemStack stack, boolean doAdd, ForgeDirection from, EnumColor color) {
            if (doAdd) {
                float cz;
                float cy;
                float cx = (float)DockingStationPipe.this.x() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetX;
                TravelingItem item = TravelingItem.make(cx, cy = (float)DockingStationPipe.this.y() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetY, cz = (float)DockingStationPipe.this.z() + 0.5f + 0.2f * (float)DockingStationPipe.this.side().offsetZ, stack);
                if (item.isCorrupted()) {
                    return 0;
                }
                ((PipeTransportItems)((Pipe)DockingStationPipe.this.getPipe().getPipe()).transport).injectItem(item, from);
            }
            return stack.stackSize;
        }
    };
    private IPipeTile pipe;

    public DockingStationPipe() {
    }

    public DockingStationPipe(IPipeTile iPipe, ForgeDirection side) {
        super(new BlockIndex(iPipe.x(), iPipe.y(), iPipe.z()), side);
        this.pipe = iPipe;
        this.world = iPipe.getWorld();
    }

    public IPipeTile getPipe() {
        TileEntity tile;
        if (this.pipe == null && (tile = this.world.getTileEntity(this.x(), this.y(), this.z())) instanceof IPipeTile) {
            this.pipe = (IPipeTile)tile;
        }
        if (this.pipe == null || ((TileEntity)this.pipe).isInvalid()) {
            RobotManager.registryProvider.getRegistry(this.world).removeStation(this);
            this.pipe = null;
        }
        return this.pipe;
    }

    @Override
    public Iterable<StatementSlot> getActiveActions() {
        return new ActionIterator(this.getPipe().getPipe());
    }

    @Override
    public IInjectable getItemOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        return this.injectablePipe;
    }

    @Override
    public ForgeDirection getItemOutputSide() {
        return this.side().getOpposite();
    }

    public ISidedInventory getItemInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeItemsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).getBlockMetadata();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        TileEntity connectedTile = this.getPipe().getWorld().getTileEntity(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        if (connectedTile instanceof IInventory) {
            return InventoryWrapper.getWrappedInventory(connectedTile);
        }
        return null;
    }

    @Override
    public ForgeDirection getItemInputSide() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return ForgeDirection.UNKNOWN;
        }
        if (!(this.getPipe().getPipe() instanceof PipeItemsWood)) {
            return ForgeDirection.UNKNOWN;
        }
        int meta = ((TileEntity)this.getPipe()).getBlockMetadata();
        return ForgeDirection.getOrientation((int)meta).getOpposite();
    }

    @Override
    public IFluidHandler getFluidInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeFluidsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).getBlockMetadata();
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        TileEntity connectedTile = this.getPipe().getWorld().getTileEntity(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
        if (connectedTile instanceof IFluidHandler) {
            return (IFluidHandler)connectedTile;
        }
        return null;
    }

    @Override
    public ForgeDirection getFluidInputSide() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return ForgeDirection.UNKNOWN;
        }
        if (!(this.getPipe().getPipe() instanceof PipeFluidsWood)) {
            return ForgeDirection.UNKNOWN;
        }
        int meta = ((TileEntity)this.getPipe()).getBlockMetadata();
        return ForgeDirection.getOrientation((int)meta).getOpposite();
    }

    @Override
    public IFluidHandler getFluidOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        return (IFluidHandler)((Pipe)this.getPipe().getPipe()).transport;
    }

    @Override
    public ForgeDirection getFluidOutputSide() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean providesPower() {
        return this.getPipe().getPipeType() == IPipeTile.PipeType.POWER;
    }

    @Override
    public IRequestProvider getRequestProvider() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity nearbyTile = this.getPipe().getWorld().getTileEntity(this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
            if (!(nearbyTile instanceof IRequestProvider)) continue;
            return (IRequestProvider)nearbyTile;
        }
        return this;
    }

    @Override
    public boolean isInitialized() {
        this.getPipe();
        if (this.pipe == null || this.pipe.getPipe() == null) {
            return false;
        }
        return ((Pipe)this.pipe.getPipe()).isInitialized();
    }

    @Override
    public boolean take(EntityRobotBase robot) {
        this.getPipe();
        if (this.pipe == null) {
            return false;
        }
        boolean result = super.take(robot);
        if (result) {
            this.pipe.scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public boolean takeAsMain(EntityRobotBase robot) {
        this.getPipe();
        if (this.pipe == null) {
            return false;
        }
        boolean result = super.takeAsMain(robot);
        if (result) {
            this.pipe.scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public void unsafeRelease(EntityRobotBase robot) {
        super.unsafeRelease(robot);
        if (this.robotTaking() == null && this.getPipe() != null) {
            this.getPipe().scheduleRenderUpdate();
        }
    }

    @Override
    public void onChunkUnload() {
        this.pipe = null;
    }

    @Override
    public int getRequestsCount() {
        return 127;
    }

    @Override
    public ItemStack getRequest(int slot) {
        ForgeDirection side = ForgeDirection.getOrientation((int)((slot & 0x70) >> 4));
        int action = (slot & 0xC) >> 2;
        int param = slot & 3;
        IGate gate = this.getPipe().getPipe().getGate(side);
        if (gate == null) {
            return null;
        }
        List<IStatement> actions = gate.getActions();
        if (actions.size() <= action) {
            return null;
        }
        if (actions.get(action) != BuildCraftRobotics.actionStationRequestItems) {
            return null;
        }
        List<StatementSlot> activeActions = gate.getActiveActions();
        StatementSlot slotStmt = null;
        for (StatementSlot stmt : activeActions) {
            if (stmt.statement != actions.get(action)) continue;
            slotStmt = stmt;
            break;
        }
        if (slotStmt == null) {
            return null;
        }
        if (slotStmt.parameters.length <= param) {
            return null;
        }
        if (slotStmt.parameters[param] == null) {
            return null;
        }
        return slotStmt.parameters[param].getItemStack();
    }

    @Override
    public ItemStack offerItem(int slot, ItemStack stack) {
        int consumed = this.injectablePipe.injectItem(stack, true, this.side.getOpposite(), null);
        if (stack.stackSize > consumed) {
            ItemStack newStack = stack.copy();
            newStack.stackSize -= consumed;
            return newStack;
        }
        return null;
    }
}

