/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.schematics;

import buildcraft.BuildCraftFactory;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.JavaTools;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.factory.TileAutoWorkbench;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicAutoWorkbench
extends SchematicTile {
    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        TileAutoWorkbench autoWb = this.getTile(context, x, y, z);
        if (autoWb != null) {
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            rqs.add(new ItemStack((Block)BuildCraftFactory.autoWorkbenchBlock));
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)autoWb.craftMatrix, ForgeDirection.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null) continue;
                stack = stack.copy();
                stack.stackSize = 1;
                rqs.add(stack);
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        this.tileNBT.removeTag("Items");
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        TileAutoWorkbench autoWb = this.getTile(context, x, y, z);
        if (autoWb != null) {
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)autoWb.craftMatrix, ForgeDirection.UP)) {
                ItemStack stack = slot.getStackInSlot();
                if (stack == null) continue;
                stack.stackSize = 1;
            }
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }

    private TileAutoWorkbench getTile(IBuilderContext context, int x, int y, int z) {
        TileEntity tile = context.world().getTileEntity(x, y, z);
        if (tile != null && tile instanceof TileAutoWorkbench) {
            return (TileAutoWorkbench)tile;
        }
        return null;
    }
}

