/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.lib.fluids.SingleUseTank;
import buildcraft.core.lib.gui.FluidSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.gui.ContainerRefinery;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiRefinery
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/refinery_filter.png");
    private final ContainerRefinery container;

    public GuiRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(new ContainerRefinery(inventory, refinery), null, TEXTURE);
        this.xSize = 175;
        this.ySize = 207;
        this.container = (ContainerRefinery)this.inventorySlots;
        this.slots.add(new FluidSlot(this, 38, 54));
        this.slots.add(new FluidSlot(this, 126, 54));
        this.slots.add(new FluidSlot(this, 82, 54));
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String title = StringUtils.localize("tile.refineryBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.fontRendererObj.drawString("->", 63, 59, 0x404040);
        this.fontRendererObj.drawString("<-", 106, 59, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 96 + 2, 0x404040);
        this.drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.updateSlots();
        this.drawBackgroundSlots(x, y);
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int position = this.getSlotIndexAtLocation(i, j);
        if (position >= 0 && position < 2) {
            if (k == 0) {
                if (!GuiRefinery.isShiftKeyDown()) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.mc.thePlayer.inventory.getItemStack());
                    if (liquid == null) {
                        return;
                    }
                    this.container.setFilter(position, liquid.getFluid());
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = liquid.getFluid().getColor(liquid);
                } else {
                    this.container.setFilter(position, null);
                    ((SingleUseTank)((Object)this.container.refinery.tankManager.get((int)position))).colorRenderCache = 0xFFFFFF;
                }
            } else if (position == 0) {
                this.container.setFilter(position, this.container.refinery.tanks[0].getFluidType());
            } else if (position == 1) {
                this.container.setFilter(position, this.container.refinery.tanks[1].getFluidType());
            }
        }
    }

    private void updateSlots() {
        Fluid filter0 = this.container.getFilter(0);
        Fluid filter1 = this.container.getFilter(1);
        ((FluidSlot)this.slots.get((int)0)).fluid = filter0;
        ((FluidSlot)this.slots.get((int)0)).colorRenderCache = this.container.refinery.tanks[0].colorRenderCache;
        ((FluidSlot)this.slots.get((int)1)).fluid = filter1;
        ((FluidSlot)this.slots.get((int)1)).colorRenderCache = this.container.refinery.tanks[1].colorRenderCache;
        CraftingResult<FluidStack> crafting = this.container.refinery.craftingResult;
        if (crafting != null) {
            ((FluidSlot)this.slots.get((int)2)).fluid = ((FluidStack)crafting.crafted).getFluid();
            ((FluidSlot)this.slots.get((int)2)).colorRenderCache = ((FluidStack)crafting.crafted).getFluid().getColor((FluidStack)crafting.crafted);
        } else {
            ((FluidSlot)this.slots.get((int)2)).fluid = null;
        }
    }
}

