/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.factory.TilePump;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPump
extends BlockBuildCraft {
    public BlockPump() {
        super(Material.iron);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TilePump();
    }

    @Override
    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (super.onBlockActivated(world, i, j, k, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TilePump) {
            Item equipped;
            TilePump pump = (TilePump)tile;
            if (entityplayer.isSneaking()) {
                return false;
            }
            Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, i, j, k)) {
                pump.tank.reset();
                pump.rebuildQueue();
                ((IToolWrench)equipped).wrenchUsed(entityplayer, i, j, k);
                return true;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TilePump) {
            ((TilePump)tile).onNeighborBlockChange(block);
        }
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 1;
    }
}

