/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.core.BlockHatched;
import buildcraft.factory.TileMiningWell;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockMiningWell
extends BlockHatched {
    public BlockMiningWell() {
        super(Material.ground);
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setStepSound(soundTypeStone);
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        super.breakBlock(world, x, y, z, block, meta);
        this.removePipes(world, x, y, z);
    }

    public void removePipes(World world, int x, int y, int z) {
        Block pipe;
        for (int depth = y - 1; depth > 0 && (pipe = world.getBlock(x, depth, z)) == BuildCraftFactory.plainPipeBlock; --depth) {
            world.setBlockToAir(x, depth, z);
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileMiningWell();
    }
}

